/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.CacheMode;
import io.ebean.ExpressionList;
import io.ebean.Query;
import io.ebean.Transaction;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.bean.PersistenceContext;
import io.ebeaninternal.api.LoadBeanRequest;
import io.ebeaninternal.api.LoadManyRequest;
import io.ebeaninternal.api.LoadRequest;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.core.DefaultServer;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.transaction.DefaultPersistenceContext;
import java.util.List;
import javax.persistence.EntityNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultBeanLoader {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBeanLoader.class);
    private final DefaultServer server;
    private final boolean onIterateUseExtraTxn;

    DefaultBeanLoader(DefaultServer server) {
        this.server = server;
        this.onIterateUseExtraTxn = server.getDatabasePlatform().useExtraTransactionOnIterateSecondaryQueries();
    }

    void loadMany(LoadManyRequest loadRequest) {
        SpiQuery<?> query = loadRequest.createQuery(this.server);
        this.executeQuery(loadRequest, query);
        loadRequest.postLoad();
    }

    void loadMany(BeanCollection<?> bc, boolean onlyIds) {
        EntityBean parentBean = bc.getOwnerBean();
        String propertyName = bc.getPropertyName();
        this.loadManyInternal(parentBean, propertyName, null, false, onlyIds);
    }

    void refreshMany(EntityBean parentBean, String propertyName) {
        this.loadManyInternal(parentBean, propertyName, null, true, false);
    }

    private void loadManyInternal(EntityBean parentBean, String propertyName, Transaction t, boolean refresh, boolean onlyIds) {
        boolean useManyIdCache;
        EntityBeanIntercept ebi = parentBean._ebean_getIntercept();
        PersistenceContext pc = ebi.getPersistenceContext();
        BeanDescriptor<?> parentDesc = this.server.getBeanDescriptor(parentBean.getClass());
        BeanPropertyAssocMany many = (BeanPropertyAssocMany)parentDesc.getBeanProperty(propertyName);
        BeanCollection beanCollection = null;
        ExpressionList filterMany = null;
        Object currentValue = many.getValue(parentBean);
        if (currentValue instanceof BeanCollection) {
            beanCollection = (BeanCollection)currentValue;
            filterMany = beanCollection.getFilterMany();
        }
        Object parentId = parentDesc.getId(parentBean);
        if (pc == null) {
            pc = new DefaultPersistenceContext();
            parentDesc.contextPut(pc, parentId, parentBean);
        }
        boolean bl = useManyIdCache = beanCollection != null && parentDesc.isManyPropCaching() && many.isUseCache();
        if (useManyIdCache) {
            Boolean readOnly = null;
            if (ebi.isReadOnly()) {
                readOnly = Boolean.TRUE;
            }
            if (parentDesc.cacheManyPropLoad(many, beanCollection, parentId, readOnly)) {
                return;
            }
        }
        Query query = this.server.createQuery((Class)parentDesc.getBeanType());
        if (refresh) {
            BeanCollection emptyCollection = many.createEmpty(parentBean);
            many.setValue(parentBean, emptyCollection);
            query.setLoadDescription("+refresh", null);
        } else {
            query.setLoadDescription("+lazy", null);
        }
        query.select(parentDesc.getIdBinder().getIdProperty());
        if (onlyIds) {
            query.fetch(many.getName(), many.getTargetIdProperty());
        } else {
            query.fetch(many.getName());
        }
        if (filterMany != null) {
            query.setFilterMany(many.getName(), filterMany);
        }
        query.where().idEq(parentId);
        query.setUseCache(false);
        query.setMode(SpiQuery.Mode.LAZYLOAD_MANY);
        query.setLazyLoadManyPath(many.getName());
        query.setPersistenceContext(pc);
        if (ebi.isReadOnly()) {
            query.setReadOnly(true);
        }
        this.server.findOne(query, t);
        if (beanCollection != null) {
            if (beanCollection.checkEmptyLazyLoad()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("BeanCollection after load was empty. Owner:" + beanCollection.getOwnerBean());
                }
            } else if (useManyIdCache) {
                parentDesc.cacheManyPropPut(many, beanCollection, parentId);
            }
        }
    }

    void loadBean(LoadBeanRequest loadRequest) {
        List<EntityBeanIntercept> batch = loadRequest.getBatch();
        if (batch.isEmpty()) {
            throw new RuntimeException("Nothing in batch?");
        }
        List<Object> idList = loadRequest.getIdList();
        if (idList.isEmpty()) {
            return;
        }
        Query query = this.server.createQuery((Class)loadRequest.getBeanType());
        loadRequest.configureQuery((SpiQuery<?>)query, idList);
        if (loadRequest.isLoadedFromCache()) {
            query.setBeanCacheMode(CacheMode.PUT);
        }
        List<?> list = this.executeQuery(loadRequest, (SpiQuery<?>)query);
        loadRequest.postLoad(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<?> executeQuery(LoadRequest loadRequest, SpiQuery<?> query) {
        if (this.onIterateUseExtraTxn && loadRequest.isParentFindIterate()) {
            SpiTransaction extraTxn = this.server.createReadOnlyTransaction(query.getTenantId());
            try {
                List<?> list = this.server.findList(query, (Transaction)extraTxn);
                return list;
            }
            finally {
                extraTxn.end();
            }
        }
        return this.server.findList(query, loadRequest.getTransaction());
    }

    public void refresh(EntityBean bean) {
        this.refreshBeanInternal(bean, SpiQuery.Mode.REFRESH_BEAN, -1);
    }

    void loadBean(EntityBeanIntercept ebi) {
        this.refreshBeanInternal(ebi.getOwner(), SpiQuery.Mode.LAZYLOAD_BEAN, -1);
    }

    private void refreshBeanInternal(EntityBean bean, SpiQuery.Mode mode, int embeddedOwnerIndex) {
        Object dbBean;
        BeanDescriptor<?> desc;
        EntityBeanIntercept ebi = bean._ebean_getIntercept();
        PersistenceContext pc = ebi.getPersistenceContext();
        if (SpiQuery.Mode.REFRESH_BEAN == mode) {
            pc = null;
        }
        if (BeanDescriptor.EntityType.EMBEDDED == (desc = this.server.getBeanDescriptor(bean.getClass())).getEntityType()) {
            EntityBean embeddedOwner = (EntityBean)ebi.getEmbeddedOwner();
            int ownerIndex = ebi.getEmbeddedOwnerIndex();
            this.refreshBeanInternal(embeddedOwner, mode, ownerIndex);
        }
        Object id = desc.getId(bean);
        if (pc == null) {
            pc = new DefaultPersistenceContext();
            desc.contextPut(pc, id, bean);
            ebi.setPersistenceContext(pc);
        }
        boolean draft = desc.isDraftInstance(bean);
        if (embeddedOwnerIndex == -1) {
            if (desc.lazyLoadMany(ebi)) {
                return;
            }
            if (!draft && SpiQuery.Mode.LAZYLOAD_BEAN == mode && desc.isBeanCaching() && desc.cacheBeanLoad(bean, ebi, id, pc)) {
                return;
            }
        }
        Query query = this.server.createQuery((Class)desc.getBeanType());
        query.setLazyLoadProperty(ebi.getLazyLoadProperty());
        if (draft) {
            query.asDraft();
        }
        if (embeddedOwnerIndex > -1) {
            query.select(ebi.getProperty(embeddedOwnerIndex));
        }
        query.setUsageProfiling(false);
        query.setPersistenceContext(pc);
        query.setMode(mode);
        query.setId(id);
        if (embeddedOwnerIndex > -1 || mode == SpiQuery.Mode.REFRESH_BEAN) {
            query.setUseCache(false);
        }
        if (ebi.isReadOnly()) {
            query.setReadOnly(true);
        }
        if (SpiQuery.Mode.REFRESH_BEAN == mode) {
            query.select("*");
        }
        if ((dbBean = query.findOne()) == null) {
            String msg = "Bean not found during lazy load or refresh. id[" + id + "] type[" + desc.getBeanType() + "]";
            throw new EntityNotFoundException(msg);
        }
        desc.resetManyProperties(dbBean);
    }
}

