/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.ScriptRunner;
import io.ebean.ddlrunner.DdlRunner;
import io.ebean.ddlrunner.ScriptTransform;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.util.UrlHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.persistence.PersistenceException;

final class DScriptRunner
implements ScriptRunner {
    private static final String NEWLINE = "\n";
    private final SpiEbeanServer server;
    private final String platformName;

    DScriptRunner(SpiEbeanServer server) {
        this.server = server;
        this.platformName = this.server.getDatabasePlatform().getPlatform().base().name();
    }

    public void run(String path) {
        this.run(path, null);
    }

    public void run(String path, Map<String, String> placeholderMap) {
        this.run(this.getClass().getResource(path), path, placeholderMap);
    }

    public void run(URL resource) {
        this.run(resource, null, null);
    }

    public void run(URL resource, Map<String, String> placeholderMap) {
        this.run(resource, null, placeholderMap);
    }

    private void run(URL resource, String scriptName, Map<String, String> placeholderMap) {
        if (resource == null) {
            throw new IllegalArgumentException("resource is null?");
        }
        if (scriptName == null) {
            scriptName = resource.getFile();
        }
        String content = this.content(resource);
        this.runScript(content, scriptName, placeholderMap, false);
    }

    private String content(URL resource) {
        String string;
        block9: {
            if (resource == null) {
                throw new IllegalArgumentException("resource is null?");
            }
            InputStream inputStream = UrlHelper.openNoCache(resource);
            try {
                string = this.readContent(new InputStreamReader(inputStream));
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new PersistenceException("Failed to read script content", (Throwable)e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    public void runScript(String name, String content, boolean useAutoCommit) {
        this.runScript(content, name, null, useAutoCommit);
    }

    private void runScript(String content, String scriptName, Map<String, String> placeholderMap, boolean useAutoCommit) {
        try {
            if (placeholderMap != null) {
                content = ScriptTransform.build(null, placeholderMap).transform(content);
            }
            try (Connection connection = this.obtainConnection();){
                DdlRunner runner = new DdlRunner(useAutoCommit, scriptName, this.platformName);
                runner.runAll(content, connection);
                connection.commit();
                runner.runNonTransactional(connection);
            }
        }
        catch (SQLException e) {
            throw new PersistenceException("Failed to run script", (Throwable)e);
        }
    }

    private Connection obtainConnection() {
        try {
            return this.server.getDataSource().getConnection();
        }
        catch (SQLException e) {
            throw new PersistenceException("Failed to obtain connection to run script", (Throwable)e);
        }
    }

    private String readContent(Reader reader) throws IOException {
        StringBuilder buf = new StringBuilder();
        try (LineNumberReader lineReader = new LineNumberReader(reader);){
            String line;
            while ((line = lineReader.readLine()) != null) {
                buf.append(line).append(NEWLINE);
            }
            String string = buf.toString();
            return string;
        }
    }
}

