/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.CancelableQuery;
import io.ebean.Transaction;
import io.ebean.util.JdbcClose;
import io.ebeaninternal.api.BindParams;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiSqlBinding;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.persist.Binder;
import io.ebeaninternal.server.persist.TrimLogSql;
import io.ebeaninternal.server.util.BindParamsParser;
import io.ebeaninternal.server.util.Str;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractSqlQueryRequest
implements CancelableQuery {
    protected final SpiSqlBinding query;
    protected final SpiEbeanServer server;
    protected SpiTransaction transaction;
    private boolean createdTransaction;
    protected String sql;
    protected ResultSet resultSet;
    protected String bindLog = "";
    protected PreparedStatement pstmt;
    protected long startNano;
    private final ReentrantLock lock = new ReentrantLock();

    AbstractSqlQueryRequest(SpiEbeanServer server, SpiSqlBinding query, Transaction t) {
        this.server = server;
        this.query = query;
        this.transaction = (SpiTransaction)t;
        this.query.setCancelableQuery(this);
    }

    public void initTransIfRequired() {
        if (this.transaction == null) {
            this.transaction = this.server.currentServerTransaction();
            if (this.transaction == null || !this.transaction.isActive()) {
                this.transaction = this.server.createReadOnlyTransaction(null);
                this.createdTransaction = true;
            }
        }
    }

    public void endTransIfRequired() {
        if (this.createdTransaction) {
            this.transaction.commit();
        }
    }

    protected void flushJdbcBatchOnQuery() {
        if (this.transaction.isFlushOnQuery()) {
            this.transaction.flush();
        }
    }

    public boolean isLogSql() {
        return this.transaction.isLogSql();
    }

    public String getBindLog() {
        return this.bindLog;
    }

    abstract void setResultSet(ResultSet var1, Object var2) throws SQLException;

    public abstract boolean next() throws SQLException;

    protected abstract void requestComplete();

    public void close() {
        this.requestComplete();
        JdbcClose.close((ResultSet)this.resultSet);
        JdbcClose.close((Statement)this.pstmt);
    }

    private void prepareSql() {
        String sql = this.query.getQuery();
        BindParams bindParams = this.query.getBindParams();
        if (!bindParams.isEmpty()) {
            sql = BindParamsParser.parse(bindParams, sql);
        }
        this.sql = this.limitOffset(sql);
    }

    private String limitOffset(String sql) {
        int firstRow = this.query.getFirstRow();
        int maxRows = this.query.getMaxRows();
        if (firstRow > 0 || maxRows > 0) {
            return this.server.getDatabasePlatform().getBasicSqlLimiter().limit(sql, firstRow, maxRows);
        }
        return sql;
    }

    public void executeSql(Binder binder, SpiQuery.Type type) throws SQLException {
        this.startNano = System.nanoTime();
        this.executeAsSql(binder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAsSql(Binder binder) throws SQLException {
        this.lock.lock();
        try {
            BindParams bindParams;
            this.query.checkCancelled();
            this.prepareSql();
            Connection conn = this.transaction.getInternalConnection();
            this.pstmt = conn.prepareStatement(this.sql);
            if (this.query.getTimeout() > 0) {
                this.pstmt.setQueryTimeout(this.query.getTimeout());
            }
            if (this.query.getBufferFetchSizeHint() > 0) {
                this.pstmt.setFetchSize(this.query.getBufferFetchSizeHint());
            }
            if (!(bindParams = this.query.getBindParams()).isEmpty()) {
                this.bindLog = binder.bind(bindParams, this.pstmt, conn);
            }
            if (this.isLogSql()) {
                long micros = (System.nanoTime() - this.startNano) / 1000L;
                this.transaction.logSql(Str.add(TrimLogSql.trim(this.sql), "; --bind(", this.bindLog, ") --micros(", micros + ")"));
            }
        }
        finally {
            this.lock.unlock();
        }
        this.setResultSet(this.pstmt.executeQuery(), null);
        this.query.checkCancelled();
    }

    public String getSql() {
        return this.sql;
    }

    public void cancel() {
        this.lock.lock();
        try {
            JdbcClose.cancel((Statement)this.pstmt);
        }
        finally {
            this.lock.unlock();
        }
    }
}

