/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.api;

import io.ebeaninternal.api.TransactionEventTable;
import io.ebeaninternal.server.cache.CacheChangeSet;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanDescriptorManager;
import io.ebeaninternal.server.transaction.DeleteByIdMap;
import io.ebeaninternal.server.transaction.TransactionManager;
import io.ebeanservice.docstore.api.DocStoreUpdates;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class TransactionEvent
implements Serializable {
    private static final long serialVersionUID = 7230903304106097120L;
    private final transient boolean local;
    private TransactionEventTable eventTables;
    private transient List<PersistRequestBean<?>> listenerNotify;
    private transient DeleteByIdMap deleteByIdMap;
    private transient CacheChangeSet changeSet;

    public TransactionEvent() {
        this.local = true;
    }

    public void addDeleteById(BeanDescriptor<?> desc, Object id) {
        if (this.deleteByIdMap == null) {
            this.deleteByIdMap = new DeleteByIdMap();
        }
        this.deleteByIdMap.add(desc, id);
    }

    public void addDeleteByIdList(BeanDescriptor<?> desc, List<Object> idList) {
        if (this.deleteByIdMap == null) {
            this.deleteByIdMap = new DeleteByIdMap();
        }
        this.deleteByIdMap.addList(desc, idList);
    }

    public DeleteByIdMap getDeleteByIdMap() {
        return this.deleteByIdMap;
    }

    public boolean isLocal() {
        return this.local;
    }

    public List<PersistRequestBean<?>> getListenerNotify() {
        return this.listenerNotify;
    }

    public TransactionEventTable getEventTables() {
        return this.eventTables;
    }

    public void add(String tableName, boolean inserts, boolean updates, boolean deletes) {
        if (this.eventTables == null) {
            this.eventTables = new TransactionEventTable();
        }
        this.eventTables.add(tableName, inserts, updates, deletes);
    }

    public void add(TransactionEventTable table) {
        if (this.eventTables == null) {
            this.eventTables = new TransactionEventTable();
        }
        this.eventTables.add(table);
    }

    public void addListenerNotify(PersistRequestBean<?> request) {
        if (this.listenerNotify == null) {
            this.listenerNotify = new ArrayList();
        }
        this.listenerNotify.add(request);
    }

    public CacheChangeSet buildCacheChanges(TransactionManager manager) {
        if (this.changeSet == null && this.deleteByIdMap == null && this.eventTables == null) {
            return null;
        }
        if (this.changeSet == null) {
            this.changeSet = new CacheChangeSet();
        }
        if (this.eventTables != null && !this.eventTables.isEmpty()) {
            BeanDescriptorManager dm = manager.getBeanDescriptorManager();
            for (TransactionEventTable.TableIUD tableIUD : this.eventTables.values()) {
                dm.cacheNotify(tableIUD, this.changeSet);
            }
        }
        if (this.deleteByIdMap != null) {
            this.deleteByIdMap.notifyCache(this.changeSet);
        }
        return this.changeSet;
    }

    public void addDocStoreUpdates(DocStoreUpdates docStoreUpdates) {
        List<PersistRequestBean<?>> requests = this.getListenerNotify();
        if (requests != null) {
            for (PersistRequestBean<?> persistRequestBean : requests) {
                persistRequestBean.addDocStoreUpdates(docStoreUpdates);
            }
        }
    }

    public CacheChangeSet obtainCacheChangeSet() {
        if (this.changeSet == null) {
            this.changeSet = new CacheChangeSet();
        }
        return this.changeSet;
    }
}

