/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.api;

import io.ebeaninternal.api.BeanCacheResult;
import io.ebeaninternal.api.CacheIdLookup;
import io.ebeaninternal.server.expression.IdInExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public final class CacheIdLookupMany<T>
implements CacheIdLookup<T> {
    private final IdInExpression idInExpression;
    private int remaining;

    public CacheIdLookupMany(IdInExpression idInExpression) {
        this.idInExpression = idInExpression;
    }

    @Override
    public Collection<?> idValues() {
        return this.idInExpression.idValues();
    }

    @Override
    public List<T> removeHits(BeanCacheResult<T> cacheResult) {
        HashSet<Object> hitIds = new HashSet<Object>();
        ArrayList<T> beans = new ArrayList<T>(hitIds.size());
        for (BeanCacheResult.Entry<T> hit : cacheResult.hits()) {
            hitIds.add(hit.getKey());
            beans.add(hit.getBean());
        }
        this.remaining = this.idInExpression.removeIds(hitIds);
        return beans;
    }

    @Override
    public boolean allHits() {
        return this.remaining == 0;
    }
}

