/*
 * Decompiled with CFR 0.152.
 */
package io.ebean;

import io.ebean.FetchGroup;
import io.ebean.FetchGroupBuilder;
import io.ebean.service.SpiFetchGroupQuery;
import io.ebean.service.SpiFetchGroupService;
import io.ebean.service.SpiProfileLocationFactory;
import io.ebean.service.SpiRawSqlService;
import java.util.Iterator;
import java.util.ServiceLoader;

final class XServiceProvider {
    private static SpiRawSqlService rawSqlService = XServiceProvider.initRawSql();
    private static SpiProfileLocationFactory profileLocationFactory = XServiceProvider.initProfileLocation();
    private static SpiFetchGroupService fetchGroupService = XServiceProvider.initSpiFetchGroupService();

    XServiceProvider() {
    }

    private static SpiFetchGroupService initSpiFetchGroupService() {
        return XServiceProvider.loadFirstService(SpiFetchGroupService.class);
    }

    private static SpiRawSqlService initRawSql() {
        return XServiceProvider.loadFirstService(SpiRawSqlService.class);
    }

    private static SpiProfileLocationFactory initProfileLocation() {
        return XServiceProvider.loadFirstService(SpiProfileLocationFactory.class);
    }

    private static <T> T loadFirstService(Class<T> cls) {
        Iterator<T> loader = ServiceLoader.load(cls).iterator();
        if (loader.hasNext()) {
            return loader.next();
        }
        throw new IllegalStateException("No service implementation found for " + cls);
    }

    static SpiRawSqlService rawSql() {
        return rawSqlService;
    }

    static SpiProfileLocationFactory profileLocationFactory() {
        return profileLocationFactory;
    }

    static <T> FetchGroup<T> fetchGroupOf(Class<T> cls, String select) {
        return fetchGroupService.of(cls, select);
    }

    static <T> FetchGroupBuilder<T> fetchGroupOf(Class<T> cls) {
        return fetchGroupService.of(cls);
    }

    static <T> SpiFetchGroupQuery<T> fetchGroupQueryFor(Class<T> cls) {
        return fetchGroupService.queryFor(cls);
    }
}

