/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.common;

import io.ebean.bean.EntityBean;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

class ModifyHolder<E>
implements Serializable {
    private static final long serialVersionUID = 2572572897923801083L;
    private Set<E> modifyDeletions = new LinkedHashSet();
    private Set<E> modifyAdditions = new LinkedHashSet();
    private boolean touched;

    ModifyHolder() {
    }

    void reset() {
        this.touched = false;
        this.modifyDeletions = new LinkedHashSet();
        this.modifyAdditions = new LinkedHashSet();
    }

    void modifyAdditionAll(Collection<? extends E> c) {
        if (c != null) {
            for (E e : c) {
                this.modifyAddition(e);
            }
        }
    }

    private boolean undoDeletion(E bean) {
        return bean != null && this.modifyDeletions.remove(bean);
    }

    void modifyAddition(E bean) {
        if (bean != null) {
            this.touched = true;
            if (bean instanceof EntityBean) {
                ((EntityBean)bean)._ebean_getIntercept().setDeletedFromCollection(false);
            }
            if (!this.undoDeletion(bean)) {
                this.modifyAdditions.add(bean);
            }
        }
    }

    private boolean undoAddition(Object bean) {
        return bean != null && this.modifyAdditions.remove(bean);
    }

    void modifyRemoval(Object bean) {
        if (bean != null) {
            this.touched = true;
            if (bean instanceof EntityBean) {
                ((EntityBean)bean)._ebean_getIntercept().setDeletedFromCollection(true);
            }
            if (!this.undoAddition(bean)) {
                this.modifyDeletions.add(bean);
            }
        }
    }

    Set<E> getModifyAdditions() {
        return this.modifyAdditions;
    }

    Set<E> getModifyRemovals() {
        return this.modifyDeletions;
    }

    boolean wasTouched() {
        return this.touched;
    }

    boolean hasModifications() {
        return !this.modifyDeletions.isEmpty() || !this.modifyAdditions.isEmpty();
    }
}

