/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.text.csv;

import io.ebean.Database;
import io.ebean.Transaction;
import io.ebean.text.csv.CsvCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCsvCallback<T>
implements CsvCallback<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultCsvCallback.class);
    protected Transaction transaction;
    protected boolean createdTransaction;
    protected Database server;
    protected final int logInfoFrequency;
    protected final int persistBatchSize;
    protected long startTime;
    protected long exeTime;

    public DefaultCsvCallback() {
        this(30, 1000);
    }

    public DefaultCsvCallback(int persistBatchSize, int logInfoFrequency) {
        this.persistBatchSize = persistBatchSize;
        this.logInfoFrequency = logInfoFrequency;
    }

    @Override
    public void begin(Database server) {
        this.server = server;
        this.startTime = System.currentTimeMillis();
        this.initTransactionIfRequired();
    }

    @Override
    public void readHeader(String[] line) {
    }

    @Override
    public boolean processLine(int row, String[] line) {
        return true;
    }

    @Override
    public void processBean(int row, String[] line, T bean) {
        this.server.save(bean, this.transaction);
        if (this.logInfoFrequency > 0 && row % this.logInfoFrequency == 0) {
            log.debug("processed {} rows", (Object)row);
        }
    }

    @Override
    public void end(int row) {
        this.commitTransactionIfCreated();
        this.exeTime = System.currentTimeMillis() - this.startTime;
        log.info("Csv finished, rows[{}] exeMillis[{}]", (Object)row, (Object)this.exeTime);
    }

    @Override
    public void endWithError(int row, Exception e) {
        this.rollbackTransactionIfCreated(e);
    }

    protected void initTransactionIfRequired() {
        this.transaction = this.server.currentTransaction();
        if (this.transaction == null || !this.transaction.isActive()) {
            this.transaction = this.server.beginTransaction();
            this.createdTransaction = true;
            if (this.persistBatchSize > 1) {
                log.debug("Creating transaction, batchSize[{}]", (Object)this.persistBatchSize);
                this.transaction.setBatchMode(true);
                this.transaction.setBatchSize(this.persistBatchSize);
                this.transaction.setGetGeneratedKeys(false);
            } else {
                this.transaction.setBatchMode(false);
                log.debug("Creating transaction with no JDBC batching");
            }
        }
    }

    protected void commitTransactionIfCreated() {
        if (this.createdTransaction) {
            this.transaction.commit();
            log.debug("Committed transaction");
        }
    }

    protected void rollbackTransactionIfCreated(Throwable e) {
        if (this.createdTransaction) {
            this.transaction.rollback(e);
            log.debug("Rolled back transaction");
        }
    }
}

