/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config.dbplatform.h2;

import io.ebean.BackgroundExecutor;
import io.ebean.config.dbplatform.SequenceBatchIdGenerator;
import javax.sql.DataSource;

public class H2SequenceIdGenerator
extends SequenceBatchIdGenerator {
    private final String baseSql;
    private final String unionBaseSql;

    public H2SequenceIdGenerator(BackgroundExecutor be, DataSource ds, String seqName, int batchSize) {
        super(be, ds, seqName, batchSize);
        this.baseSql = "select nextval('" + seqName + "')";
        this.unionBaseSql = " union " + this.baseSql;
    }

    @Override
    public String getSql(int batchSize) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.baseSql);
        for (int i = 1; i < batchSize; ++i) {
            sb.append(this.unionBaseSql);
        }
        return sb.toString();
    }
}

