/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config;

import io.ebean.annotation.Platform;
import io.ebean.config.CustomDbTypeMapping;
import io.ebean.config.DbConstraintNaming;
import io.ebean.config.PropertiesWrapper;
import io.ebean.config.dbplatform.DbType;
import io.ebean.config.dbplatform.IdType;
import io.ebean.util.StringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PlatformConfig {
    private boolean allQuotedIdentifiers;
    private boolean forUpdateNoKey;
    private DbConstraintNaming constraintNaming;
    private boolean customConstraintNaming;
    private String databaseBooleanTrue;
    private String databaseBooleanFalse;
    private int databaseSequenceBatchSize = 20;
    private IdType idType;
    private int geometrySRID = 4326;
    private DbUuid dbUuid = DbUuid.AUTO_VARCHAR;
    private boolean databaseInetAddressVarchar;
    private boolean caseSensitiveCollation = true;
    private List<CustomDbTypeMapping> customDbTypeMappings = new ArrayList<CustomDbTypeMapping>();

    public PlatformConfig() {
        this.constraintNaming = new DbConstraintNaming();
    }

    public PlatformConfig(PlatformConfig platformConfig) {
        this.forUpdateNoKey = platformConfig.forUpdateNoKey;
        this.databaseBooleanFalse = platformConfig.databaseBooleanFalse;
        this.databaseBooleanTrue = platformConfig.databaseBooleanTrue;
        this.databaseSequenceBatchSize = platformConfig.databaseSequenceBatchSize;
        this.idType = platformConfig.idType;
        this.geometrySRID = platformConfig.geometrySRID;
        this.dbUuid = platformConfig.dbUuid;
        this.caseSensitiveCollation = platformConfig.caseSensitiveCollation;
        this.allQuotedIdentifiers = platformConfig.allQuotedIdentifiers;
        this.databaseInetAddressVarchar = platformConfig.databaseInetAddressVarchar;
        this.customDbTypeMappings = platformConfig.customDbTypeMappings;
        this.constraintNaming = new DbConstraintNaming(!this.allQuotedIdentifiers);
    }

    public DbConstraintNaming getConstraintNaming() {
        return this.constraintNaming;
    }

    public void setConstraintNaming(DbConstraintNaming constraintNaming) {
        this.customConstraintNaming = true;
        this.constraintNaming = constraintNaming;
    }

    public boolean isAllQuotedIdentifiers() {
        return this.allQuotedIdentifiers;
    }

    public void setAllQuotedIdentifiers(boolean allQuotedIdentifiers) {
        this.allQuotedIdentifiers = allQuotedIdentifiers;
        if (!this.customConstraintNaming) {
            this.constraintNaming = new DbConstraintNaming(!allQuotedIdentifiers);
        }
    }

    public boolean isCaseSensitiveCollation() {
        return this.caseSensitiveCollation;
    }

    public void setCaseSensitiveCollation(boolean caseSensitiveCollation) {
        this.caseSensitiveCollation = caseSensitiveCollation;
    }

    public boolean isForUpdateNoKey() {
        return this.forUpdateNoKey;
    }

    public void setForUpdateNoKey(boolean forUpdateNoKey) {
        this.forUpdateNoKey = forUpdateNoKey;
    }

    public String getDatabaseBooleanTrue() {
        return this.databaseBooleanTrue;
    }

    public void setDatabaseBooleanTrue(String databaseBooleanTrue) {
        this.databaseBooleanTrue = databaseBooleanTrue;
    }

    public String getDatabaseBooleanFalse() {
        return this.databaseBooleanFalse;
    }

    public void setDatabaseBooleanFalse(String databaseBooleanFalse) {
        this.databaseBooleanFalse = databaseBooleanFalse;
    }

    public int getDatabaseSequenceBatchSize() {
        return this.databaseSequenceBatchSize;
    }

    public void setDatabaseSequenceBatchSize(int databaseSequenceBatchSize) {
        this.databaseSequenceBatchSize = databaseSequenceBatchSize;
    }

    public int getGeometrySRID() {
        return this.geometrySRID;
    }

    public void setGeometrySRID(int geometrySRID) {
        this.geometrySRID = geometrySRID;
    }

    public DbUuid getDbUuid() {
        return this.dbUuid;
    }

    public void setDbUuid(DbUuid dbUuid) {
        this.dbUuid = dbUuid;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public void setIdType(IdType idType) {
        this.idType = idType;
    }

    public boolean isDatabaseInetAddressVarchar() {
        return this.databaseInetAddressVarchar;
    }

    public void setDatabaseInetAddressVarchar(boolean databaseInetAddressVarchar) {
        this.databaseInetAddressVarchar = databaseInetAddressVarchar;
    }

    public void addCustomMapping(DbType type, String columnDefinition, Platform platform) {
        this.customDbTypeMappings.add(new CustomDbTypeMapping(type, columnDefinition, platform));
    }

    public void addCustomMapping(DbType type, String columnDefinition) {
        this.customDbTypeMappings.add(new CustomDbTypeMapping(type, columnDefinition));
    }

    public List<CustomDbTypeMapping> getCustomTypeMappings() {
        return this.customDbTypeMappings;
    }

    public void loadSettings(PropertiesWrapper p) {
        boolean quotedIdentifiers;
        String mapping;
        int srid;
        this.idType = p.getEnum(IdType.class, "idType", this.idType);
        this.forUpdateNoKey = p.getBoolean("forUpdateNoKey", this.forUpdateNoKey);
        this.databaseSequenceBatchSize = p.getInt("databaseSequenceBatchSize", this.databaseSequenceBatchSize);
        this.databaseBooleanTrue = p.get("databaseBooleanTrue", this.databaseBooleanTrue);
        this.databaseBooleanFalse = p.get("databaseBooleanFalse", this.databaseBooleanFalse);
        this.databaseInetAddressVarchar = p.getBoolean("databaseInetAddressVarchar", this.databaseInetAddressVarchar);
        this.caseSensitiveCollation = p.getBoolean("caseSensitiveCollation", this.caseSensitiveCollation);
        DbUuid dbUuid = p.getEnum(DbUuid.class, "dbuuid", null);
        if (dbUuid != null) {
            this.setDbUuid(dbUuid);
        }
        if (p.getBoolean("uuidStoreAsBinary", false)) {
            this.setDbUuid(DbUuid.BINARY);
        }
        if ((srid = p.getInt("geometrySRID", 0)) > 0) {
            this.setGeometrySRID(srid);
        }
        if ((mapping = p.get("mapping")) != null && !mapping.isEmpty()) {
            Map<String, String> map = StringHelper.delimitedToMap(mapping, ";", "=");
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.addCustomMapping(DbType.valueOf(entry.getKey()), entry.getValue());
            }
        }
        if ((quotedIdentifiers = p.getBoolean("allQuotedIdentifiers", this.allQuotedIdentifiers)) != this.allQuotedIdentifiers) {
            this.setAllQuotedIdentifiers(quotedIdentifiers);
        }
    }

    public static enum DbUuid {
        AUTO_VARCHAR(true, false, false),
        AUTO_BINARY(true, true, false),
        AUTO_BINARY_OPTIMIZED(true, true, true),
        VARCHAR(false, false, false),
        BINARY(false, true, false),
        BINARY_OPTIMIZED(false, true, true);

        boolean nativeType;
        boolean binary;
        boolean binaryOptimized;

        private DbUuid(boolean nativeType, boolean binary, boolean binaryOptimized) {
            this.nativeType = nativeType;
            this.binary = binary;
            this.binaryOptimized = binaryOptimized;
        }

        public boolean useNativeType() {
            return this.nativeType;
        }

        public boolean useBinary() {
            return this.binary;
        }

        public boolean useBinaryOptimized() {
            return this.binaryOptimized;
        }
    }
}

