/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.common;

import io.ebean.bean.BeanCollection;
import io.ebean.bean.BeanCollectionAdd;
import io.ebean.bean.BeanCollectionLoader;
import io.ebean.bean.EntityBean;
import io.ebean.common.AbstractBeanCollection;
import io.ebean.common.ModifyIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public final class BeanSet<E>
extends AbstractBeanCollection<E>
implements Set<E>,
BeanCollectionAdd {
    private static final long serialVersionUID = 1L;
    private Set<E> set;

    public BeanSet(Set<E> set) {
        this.set = set;
    }

    public BeanSet() {
        this(new LinkedHashSet());
    }

    public BeanSet(BeanCollectionLoader loader, EntityBean ownerBean, String propertyName) {
        super(loader, ownerBean, propertyName);
    }

    @Override
    public void reset(EntityBean ownerBean, String propertyName) {
        this.ownerBean = ownerBean;
        this.propertyName = propertyName;
        this.set = null;
    }

    @Override
    public boolean isSkipSave() {
        return this.set == null || this.set.isEmpty() && !this.holdsModifications();
    }

    @Override
    public void addEntityBean(EntityBean bean) {
        this.set.add(bean);
    }

    @Override
    public void loadFrom(BeanCollection<?> other) {
        if (this.set == null) {
            this.set = new LinkedHashSet();
        }
        this.set.addAll(other.getActualDetails());
    }

    @Override
    public void internalAddWithCheck(Object bean) {
        this.internalAdd(bean);
    }

    @Override
    public void internalAdd(Object bean) {
        if (this.set == null) {
            this.set = new LinkedHashSet();
        }
        if (bean != null) {
            this.set.add(bean);
        }
    }

    @Override
    public boolean isPopulated() {
        return this.set != null;
    }

    @Override
    public boolean isReference() {
        return this.set == null;
    }

    @Override
    public boolean checkEmptyLazyLoad() {
        if (this.set == null) {
            this.set = new LinkedHashSet();
            return true;
        }
        return false;
    }

    private void initClear() {
        this.lock.lock();
        try {
            if (this.set == null) {
                if (!this.disableLazyLoad && this.modifyListening) {
                    this.lazyLoadCollection(true);
                } else {
                    this.set = new LinkedHashSet();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void init() {
        this.lock.lock();
        try {
            if (this.set == null) {
                if (this.disableLazyLoad) {
                    this.set = new LinkedHashSet();
                } else {
                    this.lazyLoadCollection(true);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setActualSet(Set<?> set) {
        this.set = set;
    }

    public Set<E> getActualSet() {
        return this.set;
    }

    @Override
    public Collection<E> getActualDetails() {
        return this.set;
    }

    @Override
    public Collection<?> getActualEntries() {
        return this.set;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("BeanSet ");
        if (this.isReadOnly()) {
            sb.append("readOnly ");
        }
        if (this.set == null) {
            sb.append("deferred ");
        } else {
            sb.append("size[").append(this.set.size()).append("]");
            sb.append(" set").append(this.set);
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        this.init();
        return this.set.equals(obj);
    }

    @Override
    public int hashCode() {
        this.init();
        return this.set.hashCode();
    }

    @Override
    public void addBean(E bean) {
        this.add(bean);
    }

    @Override
    public void removeBean(E bean) {
        if (this.set.remove(bean)) {
            this.getModifyHolder().modifyRemoval(bean);
        }
    }

    @Override
    public boolean add(E o) {
        this.checkReadOnly();
        this.init();
        if (this.modifyListening) {
            if (this.set.add(o)) {
                this.modifyAddition((Object)o);
                return true;
            }
            return false;
        }
        return this.set.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends E> addCollection) {
        this.checkReadOnly();
        this.init();
        if (this.modifyListening) {
            boolean changed = false;
            for (E bean : addCollection) {
                if (!this.set.add(bean)) continue;
                this.modifyAddition((Object)bean);
                changed = true;
            }
            return changed;
        }
        return this.set.addAll(addCollection);
    }

    @Override
    public void clear() {
        this.checkReadOnly();
        this.initClear();
        if (this.modifyListening) {
            for (E bean : this.set) {
                this.modifyRemoval(bean);
            }
        }
        this.set.clear();
    }

    @Override
    public boolean contains(Object o) {
        this.init();
        return this.set.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.init();
        return this.set.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        this.init();
        return this.set.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        this.init();
        if (this.isReadOnly()) {
            return new ReadOnlyIterator<E>(this.set.iterator());
        }
        if (this.modifyListening) {
            return new ModifyIterator<E>(this, this.set.iterator());
        }
        return this.set.iterator();
    }

    @Override
    public boolean remove(Object o) {
        this.checkReadOnly();
        this.init();
        if (this.modifyListening) {
            if (this.set.remove(o)) {
                this.modifyRemoval(o);
                return true;
            }
            return false;
        }
        return this.set.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> beans) {
        this.checkReadOnly();
        this.init();
        if (this.modifyListening) {
            boolean changed = false;
            for (Object bean : beans) {
                if (!this.set.remove(bean)) continue;
                this.modifyRemoval(bean);
                changed = true;
            }
            return changed;
        }
        return this.set.removeAll(beans);
    }

    @Override
    public boolean retainAll(Collection<?> beans) {
        this.checkReadOnly();
        this.init();
        if (this.modifyListening) {
            boolean changed = false;
            Iterator<E> it = this.set.iterator();
            while (it.hasNext()) {
                E bean = it.next();
                if (beans.contains(bean)) continue;
                it.remove();
                this.modifyRemoval(bean);
                changed = true;
            }
            return changed;
        }
        return this.set.retainAll(beans);
    }

    @Override
    public int size() {
        this.init();
        return this.set.size();
    }

    @Override
    public Object[] toArray() {
        this.init();
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.init();
        return this.set.toArray(a);
    }

    @Override
    public BeanCollection<E> getShallowCopy() {
        BeanSet<E> copy = new BeanSet<E>(new LinkedHashSet<E>(this.set));
        copy.setFromOriginal(this);
        return copy;
    }

    private static class ReadOnlyIterator<E>
    implements Iterator<E>,
    Serializable {
        private static final long serialVersionUID = 2577697326745352605L;
        private final Iterator<E> it;

        ReadOnlyIterator(Iterator<E> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public E next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            throw new IllegalStateException("This collection is in ReadOnly mode");
        }
    }
}

