/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.bean;

import io.ebean.Database;
import io.ebean.bean.BeanLoader;
import io.ebean.bean.EntityBeanIntercept;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class SingleBeanLoader
implements BeanLoader {
    private final ReentrantLock lock = new ReentrantLock();
    protected final Database database;

    SingleBeanLoader(Database database) {
        this.database = database;
    }

    @Override
    public String getName() {
        return this.database.getName();
    }

    @Override
    public Lock lock() {
        this.lock.lock();
        return this.lock;
    }

    public static class Dflt
    extends SingleBeanLoader {
        public Dflt(Database database) {
            super(database);
        }

        @Override
        public void loadBean(EntityBeanIntercept ebi) {
            this.database.getPluginApi().loadBean(ebi);
        }
    }

    public static class Ref
    extends SingleBeanLoader {
        public Ref(Database database) {
            super(database);
        }

        @Override
        public void loadBean(EntityBeanIntercept ebi) {
            this.database.getPluginApi().loadBeanRef(ebi);
        }
    }

    public static class L2
    extends SingleBeanLoader {
        public L2(Database database) {
            super(database);
        }

        @Override
        public void loadBean(EntityBeanIntercept ebi) {
            this.database.getPluginApi().loadBeanL2(ebi);
        }
    }
}

