/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.bean;

import io.ebean.DB;
import io.ebean.Database;
import io.ebean.ValuePair;
import io.ebean.bean.BeanDiffVisitor;
import io.ebean.bean.BeanLoader;
import io.ebean.bean.EntityBean;
import io.ebean.bean.MutableValueInfo;
import io.ebean.bean.MutableValueNext;
import io.ebean.bean.NodeUsageCollector;
import io.ebean.bean.PersistenceContext;
import io.ebean.bean.PreGetterCallback;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceException;

public final class EntityBeanIntercept
implements Serializable {
    private static final long serialVersionUID = -3664031775464862649L;
    private static final int STATE_NEW = 0;
    private static final int STATE_REFERENCE = 1;
    private static final int STATE_LOADED = 2;
    private static final byte FLAG_LOADED_PROP = 1;
    private static final byte FLAG_CHANGED_PROP = 2;
    private static final byte FLAG_CHANGEDLOADED_PROP = 3;
    private static final byte FLAG_EMBEDDED_DIRTY = 4;
    private static final byte FLAG_ORIG_VALUE_SET = 8;
    private static final byte FLAG_MUTABLE_HASH_SET = 16;
    private final transient ReentrantLock lock = new ReentrantLock();
    private transient NodeUsageCollector nodeUsageCollector;
    private transient PersistenceContext persistenceContext;
    private transient BeanLoader beanLoader;
    private transient PreGetterCallback preGetterCallback;
    private String ebeanServerName;
    private boolean deletedFromCollection;
    private final EntityBean owner;
    private EntityBean embeddedOwner;
    private int embeddedOwnerIndex;
    private int state;
    private boolean forceUpdate;
    private boolean readOnly;
    private boolean dirty;
    private boolean disableLazyLoad;
    private boolean lazyLoadFailure;
    private boolean fullyLoadedBean;
    private boolean loadedFromCache;
    private final byte[] flags;
    private Object[] origValues;
    private Exception[] loadErrors;
    private int lazyLoadProperty = -1;
    private Object ownerId;
    private int sortOrder;
    private MutableValueInfo[] mutableInfo;
    private MutableValueNext[] mutableNext;

    public EntityBeanIntercept(Object ownerBean) {
        this.owner = (EntityBean)ownerBean;
        this.flags = new byte[this.owner._ebean_getPropertyNames().length];
    }

    public EntityBeanIntercept() {
        this.owner = null;
        this.flags = null;
    }

    public EntityBean getOwner() {
        return this.owner;
    }

    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    public void setPersistenceContext(PersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public void setNodeUsageCollector(NodeUsageCollector usageCollector) {
        this.nodeUsageCollector = usageCollector;
    }

    public Object getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(Object ownerId) {
        this.ownerId = ownerId;
    }

    public Object getEmbeddedOwner() {
        return this.embeddedOwner;
    }

    public int getEmbeddedOwnerIndex() {
        return this.embeddedOwnerIndex;
    }

    public void clearGetterCallback() {
        this.preGetterCallback = null;
    }

    public void registerGetterCallback(PreGetterCallback getterCallback) {
        this.preGetterCallback = getterCallback;
    }

    public void setEmbeddedOwner(EntityBean parentBean, int embeddedOwnerIndex) {
        this.embeddedOwner = parentBean;
        this.embeddedOwnerIndex = embeddedOwnerIndex;
    }

    public void setBeanLoader(BeanLoader beanLoader, PersistenceContext ctx) {
        this.beanLoader = beanLoader;
        this.persistenceContext = ctx;
        this.ebeanServerName = beanLoader.getName();
    }

    public void setBeanLoader(BeanLoader beanLoader) {
        this.beanLoader = beanLoader;
        this.ebeanServerName = beanLoader.getName();
    }

    public boolean isFullyLoadedBean() {
        return this.fullyLoadedBean;
    }

    public void setFullyLoadedBean(boolean fullyLoadedBean) {
        this.fullyLoadedBean = fullyLoadedBean;
    }

    public boolean isPartial() {
        for (byte flag : this.flags) {
            if ((flag & 1) != 0) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        if (this.dirty) {
            return true;
        }
        if (this.mutableInfo != null) {
            for (int i = 0; i < this.mutableInfo.length; ++i) {
                if (this.mutableInfo[i] == null || this.mutableInfo[i].isEqualToObject(this.owner._ebean_getField(i))) continue;
                this.dirty = true;
                break;
            }
        }
        return this.dirty;
    }

    public void setEmbeddedDirty(int embeddedProperty) {
        this.dirty = true;
        this.setEmbeddedPropertyDirty(embeddedProperty);
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isNew() {
        return this.state == 0;
    }

    public boolean isNewOrDirty() {
        return this.isNew() || this.isDirty();
    }

    public boolean hasIdOnly(int idIndex) {
        for (int i = 0; i < this.flags.length; ++i) {
            if (!(i == idIndex ? (this.flags[i] & 1) == 0 : (this.flags[i] & 1) != 0)) continue;
            return false;
        }
        return true;
    }

    public boolean isReference() {
        return this.state == 1;
    }

    public void setReference(int idPos) {
        this.state = 1;
        if (idPos > -1) {
            for (int i = 0; i < this.flags.length; ++i) {
                if (i == idPos) continue;
                int n = i;
                this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
            }
        }
    }

    public void setLoadedFromCache(boolean loadedFromCache) {
        this.loadedFromCache = loadedFromCache;
    }

    public boolean isLoadedFromCache() {
        return this.loadedFromCache;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }

    public boolean isUpdate() {
        return this.forceUpdate || this.state == 2;
    }

    public boolean isLoaded() {
        return this.state == 2;
    }

    public void setNew() {
        this.state = 0;
    }

    public void setLoaded() {
        this.state = 2;
        this.owner._ebean_setEmbeddedLoaded();
        this.lazyLoadProperty = -1;
        this.origValues = null;
        this.mutableNext = null;
        int i = 0;
        while (i < this.flags.length) {
            int n = i++;
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFF5);
        }
        this.dirty = false;
    }

    public void setLoadedLazy() {
        this.state = 2;
        this.lazyLoadProperty = -1;
    }

    public void setLazyLoadFailure(Object ownerId) {
        this.lazyLoadFailure = true;
        this.ownerId = ownerId;
    }

    public boolean isLazyLoadFailure() {
        return this.lazyLoadFailure;
    }

    public boolean isDisableLazyLoad() {
        return this.disableLazyLoad;
    }

    public void setDisableLazyLoad(boolean disableLazyLoad) {
        this.disableLazyLoad = disableLazyLoad;
    }

    public void setEmbeddedLoaded(Object embeddedBean) {
        if (embeddedBean instanceof EntityBean) {
            EntityBean eb = (EntityBean)embeddedBean;
            eb._ebean_getIntercept().setLoaded();
        }
    }

    public boolean isEmbeddedNewOrDirty(Object embeddedBean) {
        if (embeddedBean == null) {
            return false;
        }
        if (embeddedBean instanceof EntityBean) {
            return ((EntityBean)embeddedBean)._ebean_getIntercept().isNewOrDirty();
        }
        return true;
    }

    public Object getOrigValue(int propertyIndex) {
        if ((this.flags[propertyIndex] & 0x18) == 16) {
            this.setOriginalValue(propertyIndex, this.mutableInfo[propertyIndex].get());
        }
        if (this.origValues == null) {
            return null;
        }
        return this.origValues[propertyIndex];
    }

    public int findProperty(String propertyName) {
        String[] names = this.owner._ebean_getPropertyNames();
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(propertyName)) continue;
            return i;
        }
        return -1;
    }

    public String getProperty(int propertyIndex) {
        if (propertyIndex == -1) {
            return null;
        }
        return this.owner._ebean_getPropertyName(propertyIndex);
    }

    public int getPropertyLength() {
        return this.flags.length;
    }

    public void setPropertyLoaded(String propertyName, boolean loaded) {
        int position = this.findProperty(propertyName);
        if (position == -1) {
            throw new IllegalArgumentException("Property " + propertyName + " not found");
        }
        if (loaded) {
            int n = position;
            this.flags[n] = (byte)(this.flags[n] | 1);
        } else {
            int n = position;
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        }
    }

    public void setPropertyUnloaded(int propertyIndex) {
        int n = propertyIndex;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
    }

    public void setLoadedProperty(int propertyIndex) {
        int n = propertyIndex;
        this.flags[n] = (byte)(this.flags[n] | 1);
    }

    public void setLoadedPropertyAll() {
        int i = 0;
        while (i < this.flags.length) {
            int n = i++;
            this.flags[n] = (byte)(this.flags[n] | 1);
        }
    }

    public boolean isLoadedProperty(int propertyIndex) {
        return (this.flags[propertyIndex] & 1) != 0;
    }

    public boolean isChangedProperty(int propertyIndex) {
        return (this.flags[propertyIndex] & 2) != 0;
    }

    public boolean isDirtyProperty(int propertyIndex) {
        return (this.flags[propertyIndex] & 6) != 0;
    }

    public void markPropertyAsChanged(int propertyIndex) {
        this.setChangedProperty(propertyIndex);
        this.setDirty(true);
    }

    public void setChangedProperty(int propertyIndex) {
        int n = propertyIndex;
        this.flags[n] = (byte)(this.flags[n] | 2);
    }

    private void setChangeLoaded(int propertyIndex) {
        int n = propertyIndex;
        this.flags[n] = (byte)(this.flags[n] | 3);
    }

    private void setEmbeddedPropertyDirty(int propertyIndex) {
        int n = propertyIndex;
        this.flags[n] = (byte)(this.flags[n] | 4);
    }

    private void setOriginalValue(int propertyIndex, Object value) {
        if (this.origValues == null) {
            this.origValues = new Object[this.flags.length];
        }
        if ((this.flags[propertyIndex] & 8) == 0) {
            int n = propertyIndex;
            this.flags[n] = (byte)(this.flags[n] | 8);
            this.origValues[propertyIndex] = value;
        }
    }

    private void setOriginalValueForce(int propertyIndex, Object value) {
        if (this.origValues == null) {
            this.origValues = new Object[this.flags.length];
        }
        this.origValues[propertyIndex] = value;
    }

    public void setNewBeanForUpdate() {
        for (int i = 0; i < this.flags.length; ++i) {
            if ((this.flags[i] & 1) == 0) continue;
            int n = i;
            this.flags[n] = (byte)(this.flags[n] | 2);
        }
        this.setDirty(true);
    }

    public Set<String> getLoadedPropertyNames() {
        if (this.fullyLoadedBean) {
            return null;
        }
        LinkedHashSet<String> props = new LinkedHashSet<String>();
        for (int i = 0; i < this.flags.length; ++i) {
            if ((this.flags[i] & 1) == 0) continue;
            props.add(this.getProperty(i));
        }
        return props;
    }

    public boolean[] getDirtyProperties() {
        int len = this.getPropertyLength();
        boolean[] dirties = new boolean[len];
        for (int i = 0; i < len; ++i) {
            dirties[i] = (this.flags[i] & 6) != 0;
        }
        return dirties;
    }

    public Set<String> getDirtyPropertyNames() {
        LinkedHashSet<String> props = new LinkedHashSet<String>();
        this.addDirtyPropertyNames(props, null);
        return props;
    }

    public void addDirtyPropertyNames(Set<String> props, String prefix) {
        int len = this.getPropertyLength();
        for (int i = 0; i < len; ++i) {
            if (this.isChangedProp(i)) {
                props.add(prefix == null ? this.getProperty(i) : prefix + this.getProperty(i));
                continue;
            }
            if ((this.flags[i] & 4) == 0) continue;
            EntityBean embeddedBean = (EntityBean)this.owner._ebean_getField(i);
            embeddedBean._ebean_getIntercept().addDirtyPropertyNames(props, this.getProperty(i) + ".");
        }
    }

    public boolean hasDirtyProperty(Set<String> propertyNames) {
        String[] names = this.owner._ebean_getPropertyNames();
        int len = this.getPropertyLength();
        for (int i = 0; i < len; ++i) {
            if (!(this.isChangedProp(i) ? propertyNames.contains(names[i]) : (this.flags[i] & 4) != 0 && propertyNames.contains(names[i]))) continue;
            return true;
        }
        return false;
    }

    public Map<String, ValuePair> getDirtyValues() {
        LinkedHashMap<String, ValuePair> dirtyValues = new LinkedHashMap<String, ValuePair>();
        this.addDirtyPropertyValues(dirtyValues, null);
        return dirtyValues;
    }

    public void addDirtyPropertyValues(Map<String, ValuePair> dirtyValues, String prefix) {
        int len = this.getPropertyLength();
        for (int i = 0; i < len; ++i) {
            if (this.isChangedProp(i)) {
                String propName = prefix == null ? this.getProperty(i) : prefix + this.getProperty(i);
                Object newVal = this.owner._ebean_getField(i);
                Object oldVal = this.getOrigValue(i);
                if (!EntityBeanIntercept.notEqual(oldVal, newVal)) continue;
                dirtyValues.put(propName, new ValuePair(newVal, oldVal));
                continue;
            }
            if ((this.flags[i] & 4) == 0) continue;
            EntityBean embeddedBean = (EntityBean)this.owner._ebean_getField(i);
            embeddedBean._ebean_getIntercept().addDirtyPropertyValues(dirtyValues, this.getProperty(i) + ".");
        }
    }

    public void addDirtyPropertyValues(BeanDiffVisitor visitor) {
        int len = this.getPropertyLength();
        for (int i = 0; i < len; ++i) {
            if (this.isChangedProp(i)) {
                Object newVal = this.owner._ebean_getField(i);
                Object oldVal = this.getOrigValue(i);
                if (!EntityBeanIntercept.notEqual(oldVal, newVal)) continue;
                visitor.visit(i, newVal, oldVal);
                continue;
            }
            if ((this.flags[i] & 4) == 0) continue;
            EntityBean embeddedBean = (EntityBean)this.owner._ebean_getField(i);
            visitor.visitPush(i);
            embeddedBean._ebean_getIntercept().addDirtyPropertyValues(visitor);
            visitor.visitPop();
        }
    }

    public StringBuilder getDirtyPropertyKey() {
        StringBuilder sb = new StringBuilder();
        this.addDirtyPropertyKey(sb);
        return sb;
    }

    private void addDirtyPropertyKey(StringBuilder sb) {
        if (this.sortOrder > 0) {
            sb.append("s,");
        }
        int len = this.getPropertyLength();
        for (int i = 0; i < len; ++i) {
            if ((this.flags[i] & 2) != 0) {
                sb.append(i).append(',');
                continue;
            }
            if ((this.flags[i] & 4) == 0) continue;
            EntityBean embeddedBean = (EntityBean)this.owner._ebean_getField(i);
            sb.append(i).append('[');
            embeddedBean._ebean_getIntercept().addDirtyPropertyKey(sb);
            sb.append(']');
        }
    }

    public StringBuilder getLoadedPropertyKey() {
        StringBuilder sb = new StringBuilder();
        int len = this.getPropertyLength();
        for (int i = 0; i < len; ++i) {
            if (!this.isLoadedProperty(i)) continue;
            sb.append(i).append(',');
        }
        return sb;
    }

    public boolean[] getLoaded() {
        boolean[] ret = new boolean[this.flags.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (this.flags[i] & 1) != 0;
        }
        return ret;
    }

    public int getLazyLoadPropertyIndex() {
        return this.lazyLoadProperty;
    }

    public String getLazyLoadProperty() {
        return this.getProperty(this.lazyLoadProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadBean(int loadProperty) {
        this.lock.lock();
        try {
            if (this.beanLoader == null) {
                Database database = DB.byName(this.ebeanServerName);
                if (database == null) {
                    throw new PersistenceException("Database [" + this.ebeanServerName + "] was not found?");
                }
                this.loadBeanInternal(loadProperty, database.getPluginApi().beanLoader());
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        Lock lock = this.beanLoader.lock();
        try {
            this.loadBeanInternal(loadProperty, this.beanLoader);
        }
        finally {
            lock.unlock();
        }
    }

    private void loadBeanInternal(int loadProperty, BeanLoader loader) {
        if ((this.flags[loadProperty] & 1) != 0) {
            return;
        }
        if (this.lazyLoadFailure) {
            throw new EntityNotFoundException("(Lazy) loading failed on type:" + this.owner.getClass().getName() + " id:" + this.ownerId + " - Bean has been deleted");
        }
        if (this.lazyLoadProperty == -1) {
            this.lazyLoadProperty = loadProperty;
            if (this.nodeUsageCollector != null) {
                this.nodeUsageCollector.setLoadProperty(this.getProperty(this.lazyLoadProperty));
            }
            loader.loadBean(this);
            if (this.lazyLoadFailure) {
                throw new EntityNotFoundException("Lazy loading failed on type:" + this.owner.getClass().getName() + " id:" + this.ownerId + " - Bean has been deleted.");
            }
        }
    }

    protected static boolean notEqual(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 != null;
        }
        if (obj2 == null) {
            return true;
        }
        if (obj1 == obj2) {
            return false;
        }
        if (obj1 instanceof BigDecimal) {
            if (obj2 instanceof BigDecimal) {
                Comparable com1 = (Comparable)obj1;
                return com1.compareTo(obj2) != 0;
            }
            return true;
        }
        if (obj1 instanceof URL) {
            return !obj1.toString().equals(obj2.toString());
        }
        return !obj1.equals(obj2);
    }

    public void initialisedMany(int propertyIndex) {
        int n = propertyIndex;
        this.flags[n] = (byte)(this.flags[n] | 1);
    }

    private void preGetterCallback(int propertyIndex) {
        PreGetterCallback preGetterCallback = this.preGetterCallback;
        if (preGetterCallback != null) {
            preGetterCallback.preGetterTrigger(propertyIndex);
        }
    }

    public void preGetId() {
        this.preGetterCallback(-1);
    }

    public void preGetter(int propertyIndex) {
        this.preGetterCallback(propertyIndex);
        if (this.state == 0 || this.disableLazyLoad) {
            return;
        }
        if (!this.isLoadedProperty(propertyIndex)) {
            this.loadBean(propertyIndex);
        }
        if (this.nodeUsageCollector != null) {
            this.nodeUsageCollector.addUsed(this.getProperty(propertyIndex));
        }
    }

    public void preSetterMany(boolean interceptField, int propertyIndex, Object oldValue, Object newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else {
            if (this.readOnly) {
                throw new IllegalStateException("This bean is readOnly");
            }
            this.setChangeLoaded(propertyIndex);
        }
    }

    private void setChangedPropertyValue(int propertyIndex, boolean setDirtyState, Object origValue) {
        if (this.readOnly) {
            throw new IllegalStateException("This bean is readOnly");
        }
        this.setChangedProperty(propertyIndex);
        if (setDirtyState) {
            this.setOriginalValue(propertyIndex, origValue);
            this.setDirtyStatus();
        }
    }

    private void setDirtyStatus() {
        if (!this.dirty) {
            this.dirty = true;
            if (this.embeddedOwner != null) {
                this.embeddedOwner._ebean_getIntercept().setEmbeddedDirty(this.embeddedOwnerIndex);
            }
            if (this.nodeUsageCollector != null) {
                this.nodeUsageCollector.setModified();
            }
        }
    }

    public void preSetter(boolean intercept, int propertyIndex, Object oldValue, Object newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (EntityBeanIntercept.notEqual(oldValue, newValue)) {
            this.setChangedPropertyValue(propertyIndex, intercept, oldValue);
        }
    }

    public void preSetter(boolean intercept, int propertyIndex, boolean oldValue, boolean newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (oldValue != newValue) {
            this.setChangedPropertyValue(propertyIndex, intercept, oldValue);
        }
    }

    public void preSetter(boolean intercept, int propertyIndex, int oldValue, int newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (oldValue != newValue) {
            this.setChangedPropertyValue(propertyIndex, intercept, oldValue);
        }
    }

    public void preSetter(boolean intercept, int propertyIndex, long oldValue, long newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (oldValue != newValue) {
            this.setChangedPropertyValue(propertyIndex, intercept, oldValue);
        }
    }

    public void preSetter(boolean intercept, int propertyIndex, double oldValue, double newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (Double.compare(oldValue, newValue) != 0) {
            this.setChangedPropertyValue(propertyIndex, intercept, oldValue);
        }
    }

    public void preSetter(boolean intercept, int propertyIndex, float oldValue, float newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (Float.compare(oldValue, newValue) != 0) {
            this.setChangedPropertyValue(propertyIndex, intercept, Float.valueOf(oldValue));
        }
    }

    public void preSetter(boolean intercept, int propertyIndex, short oldValue, short newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (oldValue != newValue) {
            this.setChangedPropertyValue(propertyIndex, intercept, oldValue);
        }
    }

    public void preSetter(boolean intercept, int propertyIndex, char oldValue, char newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (oldValue != newValue) {
            this.setChangedPropertyValue(propertyIndex, intercept, Character.valueOf(oldValue));
        }
    }

    public void preSetter(boolean intercept, int propertyIndex, byte oldValue, byte newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (oldValue != newValue) {
            this.setChangedPropertyValue(propertyIndex, intercept, oldValue);
        }
    }

    public void preSetter(boolean intercept, int propertyIndex, char[] oldValue, char[] newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (!Arrays.equals(oldValue, newValue)) {
            this.setChangedPropertyValue(propertyIndex, intercept, oldValue);
        }
    }

    public void preSetter(boolean intercept, int propertyIndex, byte[] oldValue, byte[] newValue) {
        if (this.state == 0) {
            this.setLoadedProperty(propertyIndex);
        } else if (!Arrays.equals(oldValue, newValue)) {
            this.setChangedPropertyValue(propertyIndex, intercept, oldValue);
        }
    }

    public void setOldValue(int propertyIndex, Object oldValue) {
        this.setChangedProperty(propertyIndex);
        this.setOriginalValueForce(propertyIndex, oldValue);
        this.setDirtyStatus();
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }

    public void setDeletedFromCollection(boolean deletedFromCollection) {
        this.deletedFromCollection = deletedFromCollection;
    }

    public boolean isOrphanDelete() {
        return this.deletedFromCollection && !this.isNew();
    }

    public void setLoadError(int propertyIndex, Exception t) {
        if (this.loadErrors == null) {
            this.loadErrors = new Exception[this.flags.length];
        }
        this.loadErrors[propertyIndex] = t;
        int n = propertyIndex;
        this.flags[n] = (byte)(this.flags[n] | 1);
    }

    public Map<String, Exception> getLoadErrors() {
        if (this.loadErrors == null) {
            return null;
        }
        LinkedHashMap<String, Exception> ret = null;
        int len = this.getPropertyLength();
        for (int i = 0; i < len; ++i) {
            Exception loadError = this.loadErrors[i];
            if (loadError == null) continue;
            if (ret == null) {
                ret = new LinkedHashMap<String, Exception>();
            }
            ret.put(this.getProperty(i), loadError);
        }
        return ret;
    }

    private boolean isChangedProp(int i) {
        if ((this.flags[i] & 2) != 0) {
            return true;
        }
        if (this.mutableInfo == null || this.mutableInfo[i] == null || this.mutableInfo[i].isEqualToObject(this.owner._ebean_getField(i))) {
            return false;
        }
        int n = i;
        this.flags[n] = (byte)(this.flags[n] | 2);
        this.dirty = true;
        return true;
    }

    public MutableValueInfo mutableInfo(int propertyIndex) {
        return this.mutableInfo == null ? null : this.mutableInfo[propertyIndex];
    }

    public void mutableInfo(int propertyIndex, MutableValueInfo info) {
        if (this.mutableInfo == null) {
            this.mutableInfo = new MutableValueInfo[this.flags.length];
        }
        int n = propertyIndex;
        this.flags[n] = (byte)(this.flags[n] | 0x10);
        this.mutableInfo[propertyIndex] = info;
    }

    public void mutableNext(int propertyIndex, MutableValueNext next) {
        if (this.mutableNext == null) {
            this.mutableNext = new MutableValueNext[this.flags.length];
        }
        this.mutableNext[propertyIndex] = next;
    }

    public String mutableNext(int propertyIndex) {
        if (this.mutableNext == null) {
            return null;
        }
        MutableValueNext next = this.mutableNext[propertyIndex];
        this.mutableInfo(propertyIndex, next.info());
        return next.content();
    }
}

