/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.transactional;

import io.ebean.enhance.asm.AnnotationVisitor;
import io.ebean.enhance.asm.Label;
import io.ebean.enhance.asm.MethodVisitor;
import io.ebean.enhance.asm.Opcodes;
import io.ebean.enhance.asm.Type;
import io.ebean.enhance.common.AnnotationInfo;
import io.ebean.enhance.common.AnnotationInfoVisitor;
import io.ebean.enhance.common.EnhanceConstants;
import io.ebean.enhance.common.VisitUtil;
import io.ebean.enhance.transactional.ClassAdapterTransactional;
import io.ebean.enhance.transactional.FinallyAdapter;
import io.ebean.enhance.transactional.ProfileMethodInstruction;
import java.util.ArrayList;

class MethodAdapter
extends FinallyAdapter
implements EnhanceConstants,
Opcodes {
    private static final String TX_FIELD_PREFIX = "_$ebpt";
    private static final Type txScopeType = Type.getType("Lio/ebean/TxScope;");
    private static final Type helpScopeTrans = Type.getType("Lio/ebeaninternal/api/HelpScopeTrans;");
    private final AnnotationInfo annotationInfo;
    private final ClassAdapterTransactional classAdapter;
    private final ProfileMethodInstruction profileMethod;
    private boolean transactional;
    private int posTxScope;

    MethodAdapter(ClassAdapterTransactional classAdapter, MethodVisitor mv, int access, String name, String desc) {
        super(mv, access, name, desc);
        this.classAdapter = classAdapter;
        this.profileMethod = new ProfileMethodInstruction(classAdapter, mv);
        AnnotationInfo parentInfo = classAdapter.getClassAnnotationInfo();
        AnnotationInfo interfaceInfo = classAdapter.getInterfaceTransactionalInfo(name, desc);
        if (parentInfo == null) {
            parentInfo = interfaceInfo;
        } else {
            parentInfo.setParent(interfaceInfo);
        }
        this.annotationInfo = new AnnotationInfo(parentInfo);
        this.transactional = parentInfo != null;
    }

    @Override
    public void visitCode() {
        super.visitCode();
        if (this.transactional) {
            this.finallyVisitStart();
        }
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        if (this.transactional) {
            this.finallyVisitMaxs(maxStack, maxLocals);
        } else {
            super.visitMaxs(maxStack, maxLocals);
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(desc, visible);
        if (desc.equals("Lio/ebean/annotation/Transactional;")) {
            this.transactional = true;
            return new AnnotationInfoVisitor(null, this.annotationInfo, av);
        }
        return av;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.profileMethod.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    private void setTxType(Object txType) {
        this.visitLabelLine();
        this.mv.visitVarInsn(25, this.posTxScope);
        this.mv.visitFieldInsn(178, "io/ebean/annotation/TxType", txType.toString(), "Lio/ebean/annotation/TxType;");
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setType", "(Lio/ebean/annotation/TxType;)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setTxIsolation(Object txIsolation) {
        this.visitLabelLine();
        this.mv.visitVarInsn(25, this.posTxScope);
        this.mv.visitFieldInsn(178, "io/ebean/annotation/TxIsolation", txIsolation.toString(), "Lio/ebean/annotation/TxIsolation;");
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setIsolation", "(Lio/ebean/annotation/TxIsolation;)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setTxProfileLocation(int locationField) {
        this.visitLabelLine();
        this.mv.visitVarInsn(25, this.posTxScope);
        this.mv.visitFieldInsn(178, this.classAdapter.className(), TX_FIELD_PREFIX + locationField, "Lio/ebean/ProfileLocation;");
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setProfileLocation", "(Lio/ebean/ProfileLocation;)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setBatch(Object batch) {
        this.visitLabelLine();
        this.mv.visitVarInsn(25, this.posTxScope);
        this.mv.visitFieldInsn(178, "io/ebean/annotation/PersistBatch", batch.toString(), "Lio/ebean/annotation/PersistBatch;");
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setBatch", "(Lio/ebean/annotation/PersistBatch;)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void visitLabelLine() {
        Label l6 = new Label();
        this.mv.visitLabel(l6);
        this.mv.visitLineNumber(1, l6);
    }

    private void setBatchOnCascade(Object batch) {
        this.visitLabelLine();
        this.mv.visitVarInsn(25, this.posTxScope);
        this.mv.visitFieldInsn(178, "io/ebean/annotation/PersistBatch", batch.toString(), "Lio/ebean/annotation/PersistBatch;");
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setBatchOnCascade", "(Lio/ebean/annotation/PersistBatch;)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setAutoPersistUpdates(Object autoPersistUpdates) {
        this.visitLabelLine();
        this.mv.visitVarInsn(25, this.posTxScope);
        this.mv.visitFieldInsn(178, "io/ebean/annotation/TxOption", autoPersistUpdates.toString(), "Lio/ebean/annotation/TxOption;");
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setAutoPersistUpdates", "(Lio/ebean/annotation/TxOption;)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setBatchSize(Object batchSize) {
        this.visitLabelLine();
        this.mv.visitVarInsn(25, this.posTxScope);
        VisitUtil.visitIntInsn(this.mv, Integer.parseInt(batchSize.toString()));
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setBatchSize", "(I)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setGetGeneratedKeys(Object getGeneratedKeys) {
        boolean getKeys = (Boolean)getGeneratedKeys;
        if (!getKeys) {
            this.visitLabelLine();
            this.mv.visitVarInsn(25, this.posTxScope);
            this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setSkipGeneratedKeys", "()Lio/ebean/TxScope;", false);
            this.mv.visitInsn(87);
        }
    }

    private void setReadOnly(Object readOnlyObj) {
        this.visitLabelLine();
        boolean readOnly = (Boolean)readOnlyObj;
        this.mv.visitVarInsn(25, this.posTxScope);
        if (readOnly) {
            this.mv.visitInsn(4);
        } else {
            this.mv.visitInsn(3);
        }
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setReadOnly", "(Z)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setFlushOnQuery(Object flushObj) {
        boolean flushOnQuery = (Boolean)flushObj;
        if (!flushOnQuery) {
            this.visitLabelLine();
            this.mv.visitVarInsn(25, this.posTxScope);
            this.mv.visitInsn(3);
            this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setFlushOnQuery", "(Z)Lio/ebean/TxScope;", false);
            this.mv.visitInsn(87);
        }
    }

    private void setSkipCache(Object skipCacheObj) {
        boolean skipCache = (Boolean)skipCacheObj;
        if (skipCache) {
            this.visitLabelLine();
            this.mv.visitVarInsn(25, this.posTxScope);
            this.mv.visitInsn(4);
            this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setSkipCache", "(Z)Lio/ebean/TxScope;", false);
            this.mv.visitInsn(87);
        }
    }

    private void setLabel(String label) {
        this.visitLabelLine();
        this.mv.visitVarInsn(25, this.posTxScope);
        this.mv.visitLdcInsn(label);
        this.mv.visitMethodInsn(182, "io/ebean/TxScope", "setLabel", "(Ljava/lang/String;)Lio/ebean/TxScope;", false);
        this.mv.visitInsn(87);
    }

    private void setNoRollbackFor(Object noRollbackFor) {
        for (Object aList : (ArrayList)noRollbackFor) {
            this.visitLabelLine();
            Type throwType = (Type)aList;
            this.mv.visitVarInsn(25, this.posTxScope);
            this.mv.visitLdcInsn(throwType);
            this.mv.visitMethodInsn(182, txScopeType.getInternalName(), "setNoRollbackFor", "(Ljava/lang/Class;)Lio/ebean/TxScope;", false);
            this.mv.visitInsn(87);
        }
    }

    private void setRollbackFor(Object rollbackFor) {
        for (Object aList : (ArrayList)rollbackFor) {
            this.visitLabelLine();
            Type throwType = (Type)aList;
            this.mv.visitVarInsn(25, this.posTxScope);
            this.mv.visitLdcInsn(throwType);
            this.mv.visitMethodInsn(182, txScopeType.getInternalName(), "setRollbackFor", "(Ljava/lang/Class;)Lio/ebean/TxScope;", false);
            this.mv.visitInsn(87);
        }
    }

    @Override
    protected void onMethodEnter() {
        Object rollbackFor;
        Object noRollbackFor;
        Object skipCache;
        Object flushOnQuery;
        Object readOnly;
        Object getGeneratedKeys;
        Object batchSize;
        Object batchOnCascade;
        Object batch;
        Object autoPersistUpdates;
        Object txIsolation;
        String txLabel;
        if (!this.transactional) {
            return;
        }
        int locationField = this.classAdapter.nextTransactionLocation();
        this.posTxScope = this.newLocal(txScopeType);
        this.mv.visitTypeInsn(187, txScopeType.getInternalName());
        this.mv.visitInsn(89);
        this.mv.visitMethodInsn(183, txScopeType.getInternalName(), "<init>", "()V", false);
        this.mv.visitVarInsn(58, this.posTxScope);
        Object txType = this.annotationInfo.getValue("type");
        if (txType != null) {
            this.setTxType(txType);
        }
        if (this.classAdapter.isEnableProfileLocation()) {
            this.setTxProfileLocation(locationField);
        }
        if ((txLabel = (String)this.annotationInfo.getValue("label")) != null && !txLabel.isEmpty()) {
            this.classAdapter.putTxnLabel(locationField, txLabel);
            this.setLabel(txLabel);
        }
        if ((txIsolation = this.annotationInfo.getValue("isolation")) != null) {
            this.setTxIsolation(txIsolation);
        }
        if ((autoPersistUpdates = this.annotationInfo.getValue("autoPersistUpdates")) != null && !"DEFAULT".equals(autoPersistUpdates.toString())) {
            this.setAutoPersistUpdates(autoPersistUpdates);
        }
        if ((batch = this.annotationInfo.getValue("batch")) != null) {
            this.setBatch(batch);
        }
        if ((batchOnCascade = this.annotationInfo.getValue("batchOnCascade")) != null) {
            this.setBatchOnCascade(batchOnCascade);
        }
        if ((batchSize = this.annotationInfo.getValue("batchSize")) != null) {
            this.setBatchSize(batchSize);
        }
        if ((getGeneratedKeys = this.annotationInfo.getValue("getGeneratedKeys")) != null) {
            this.setGetGeneratedKeys(getGeneratedKeys);
        }
        if ((readOnly = this.annotationInfo.getValue("readOnly")) != null) {
            this.setReadOnly(readOnly);
        }
        if ((flushOnQuery = this.annotationInfo.getValue("flushOnQuery")) != null) {
            this.setFlushOnQuery(flushOnQuery);
        }
        if ((skipCache = this.annotationInfo.getValue("skipCache")) != null) {
            this.setSkipCache(skipCache);
        }
        if ((noRollbackFor = this.annotationInfo.getValue("noRollbackFor")) != null) {
            this.setNoRollbackFor(noRollbackFor);
        }
        if ((rollbackFor = this.annotationInfo.getValue("rollbackFor")) != null) {
            this.setRollbackFor(rollbackFor);
        }
        this.mv.visitVarInsn(25, this.posTxScope);
        this.mv.visitMethodInsn(184, helpScopeTrans.getInternalName(), "enter", "(" + txScopeType.getDescriptor() + ")V", false);
    }

    @Override
    protected void onFinally(int opcode) {
        if (!this.transactional) {
            return;
        }
        if (opcode == 177) {
            this.visitInsn(1);
        } else if (opcode == 176 || opcode == 191) {
            this.dup();
        } else {
            if (opcode == 173 || opcode == 175) {
                this.dup2();
            } else {
                this.dup();
            }
            this.box(this.getReturnType());
        }
        this.visitIntInsn(17, opcode);
        this.visitMethodInsn(184, helpScopeTrans.getInternalName(), "exit", "(Ljava/lang/Object;I)V", false);
    }
}

