/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.common;

import io.ebean.enhance.asm.AnnotationVisitor;
import io.ebean.enhance.common.AnnotationInfo;

public class AnnotationInfoVisitor
extends AnnotationVisitor {
    private final AnnotationInfo info;
    private final String prefix;

    public AnnotationInfoVisitor(String prefix, AnnotationInfo info, AnnotationVisitor av) {
        super(589824, av);
        this.info = info;
        this.prefix = prefix;
        if (prefix != null) {
            info.getArrayEntry(prefix);
        }
    }

    @Override
    public void visit(String name, Object value) {
        super.visit(name, value);
        this.info.add(this.prefix, name, value);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        return this.create(name, super.visitAnnotation(name, desc));
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        return this.create(name, super.visitArray(name));
    }

    private AnnotationInfoVisitor create(String name, AnnotationVisitor underlying) {
        String newPrefix = this.prefix == null ? name : this.prefix + "." + name;
        return new AnnotationInfoVisitor(newPrefix, this.info, underlying);
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        super.visitEnum(name, desc, value);
        this.info.addEnum(this.prefix, name, value);
    }
}

