/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.ant;

import io.ebean.enhance.Transformer;
import io.ebean.enhance.ant.OfflineFileTransform;
import io.ebean.enhance.common.EnhanceContext;

public class MainTransform {
    public static void main(String[] args) {
        if (MainTransform.isHelp(args)) {
            MainTransform.printHelp();
            return;
        }
        String transformArgs = "debug=1";
        String inDir = "./target/test-classes";
        String pkg = "test";
        if (args.length > 0) {
            inDir = args[0];
        }
        if (args.length > 1) {
            pkg = args[1];
        }
        if (args.length > 2) {
            transformArgs = args[2];
        }
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        Transformer t = new Transformer(cl, transformArgs);
        OfflineFileTransform ft = new OfflineFileTransform(t, cl, inDir);
        EnhanceContext enhanceContext = t.getEnhanceContext();
        if (enhanceContext.getLogLevel() > 0) {
            System.out.println(enhanceContext.getPackagesSummary());
        }
        ft.process(pkg);
    }

    private static void printHelp() {
        System.out.println("Usage: [inputDirectory] [packages] [transformArguments]");
    }

    private static boolean isHelp(String[] args) {
        for (String arg : args) {
            if (arg.equalsIgnoreCase("help")) {
                return true;
            }
            if (!arg.equalsIgnoreCase("-h")) continue;
            return true;
        }
        return false;
    }
}

