/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.guava;

import com.google.common.base.Optional;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.ClassTypePair;

@Singleton
public class OptionalParamConverterProvider
implements ParamConverterProvider {
    private final InjectionManager manager;

    @Inject
    public OptionalParamConverterProvider(InjectionManager manager) {
        this.manager = manager;
    }

    public <T> @Nullable ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (Optional.class.equals(rawType)) {
            ClassTypePair ctp;
            List ctps = ReflectionHelper.getTypeArgumentAndClass((Type)genericType);
            ClassTypePair classTypePair = ctp = ctps.size() == 1 ? (ClassTypePair)ctps.get(0) : null;
            if (ctp == null || ctp.rawClass() == String.class) {
                return new ParamConverter<T>(){

                    public T fromString(String value) {
                        return rawType.cast(Optional.fromNullable((Object)value));
                    }

                    public String toString(T value) {
                        return value.toString();
                    }
                };
            }
            for (ParamConverterProvider provider : Providers.getProviders((InjectionManager)this.manager, ParamConverterProvider.class)) {
                final ParamConverter converter = provider.getConverter(ctp.rawClass(), ctp.type(), annotations);
                if (converter == null) continue;
                return new ParamConverter<T>(){

                    public T fromString(String value) {
                        Object convertedValue = value == null ? null : converter.fromString(value);
                        return rawType.cast(Optional.fromNullable((Object)convertedValue));
                    }

                    public String toString(T value) {
                        return value.toString();
                    }
                };
            }
        }
        return null;
    }
}

