/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.errors;

import io.dropwizard.jersey.errors.ErrorMessage;
import io.dropwizard.jersey.errors.LoggingExceptionMapper;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.slf4j.LoggerFactory;

@Provider
public class IllegalStateExceptionMapper
extends LoggingExceptionMapper<IllegalStateException> {
    public IllegalStateExceptionMapper() {
        super(LoggerFactory.getLogger(IllegalStateExceptionMapper.class));
    }

    @Override
    public Response toResponse(IllegalStateException exception) {
        String message = exception.getMessage();
        if (LocalizationMessages.FORM_PARAM_CONTENT_TYPE_ERROR().equals(message)) {
            this.logger.debug("If the HTTP method is POST and using @FormParam in a resource method, Content-Type should be application/x-www-form-urlencoded.", (Throwable)exception);
            return this.createResponse((WebApplicationException)new NotSupportedException());
        }
        return super.toResponse(exception);
    }

    private Response createResponse(WebApplicationException exception) {
        ErrorMessage errorMessage = new ErrorMessage(exception.getResponse().getStatus(), exception.getLocalizedMessage());
        return Response.status((int)errorMessage.getCode()).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)errorMessage).build();
    }
}

