/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.optional;

import io.dropwizard.jersey.DefaultValueUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

@Singleton
public class OptionalIntParamConverterProvider
implements ParamConverterProvider {
    private final OptionalIntParamConverter paramConverter = new OptionalIntParamConverter();

    @Nullable
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (!OptionalInt.class.equals(rawType)) {
            return null;
        }
        String defaultValue = DefaultValueUtils.getDefaultValue(annotations);
        return defaultValue == null ? this.paramConverter : new OptionalIntParamConverter(defaultValue);
    }

    public static class OptionalIntParamConverter
    implements ParamConverter<OptionalInt> {
        @Nullable
        private final String defaultValue;

        public OptionalIntParamConverter() {
            this(null);
        }

        public OptionalIntParamConverter(@Nullable String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Nullable
        public OptionalInt fromString(String value) {
            try {
                int i = Integer.parseInt(value);
                return OptionalInt.of(i);
            }
            catch (NullPointerException | NumberFormatException e) {
                if (this.defaultValue != null) {
                    if (this.defaultValue.equals(value)) {
                        throw e;
                    }
                    if (value == null || value.isEmpty()) {
                        return null;
                    }
                }
                return OptionalInt.empty();
            }
        }

        public String toString(OptionalInt value) {
            if (value == null) {
                throw new IllegalArgumentException("value must not be null");
            }
            return value.isPresent() ? Integer.toString(value.getAsInt()) : "";
        }
    }
}

