/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jersey2.InstrumentedResourceMethodApplicationListener;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import io.dropwizard.jersey.caching.CacheControlledResponseFeature;
import io.dropwizard.jersey.guava.OptionalMessageBodyWriter;
import io.dropwizard.jersey.guava.OptionalParamFeature;
import io.dropwizard.jersey.optional.OptionalDoubleMessageBodyWriter;
import io.dropwizard.jersey.optional.OptionalIntMessageBodyWriter;
import io.dropwizard.jersey.optional.OptionalLongMessageBodyWriter;
import io.dropwizard.jersey.params.AbstractParamConverterProvider;
import io.dropwizard.jersey.sessions.SessionFactoryProvider;
import io.dropwizard.jersey.validation.FuzzyEnumParamConverterProvider;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardResourceConfig
extends ResourceConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropwizardResourceConfig.class);
    private static final String NEWLINE = String.format("%n", new Object[0]);
    private static final TypeResolver TYPE_RESOLVER = new TypeResolver();
    private static final Pattern PATH_DIRTY_SLASHES = Pattern.compile("\\s*/\\s*/+\\s*");
    private String urlPattern = "/*";
    private String contextPath = "/";

    public DropwizardResourceConfig(MetricRegistry metricRegistry) {
        this(false, metricRegistry);
    }

    public DropwizardResourceConfig() {
        this(true, null);
    }

    public DropwizardResourceConfig(boolean testOnly, @Nullable MetricRegistry metricRegistry) {
        if (metricRegistry == null) {
            metricRegistry = new MetricRegistry();
        }
        this.property("jersey.config.server.wadl.disableWadl", Boolean.TRUE);
        if (!testOnly) {
            this.register(new ComponentLoggingListener(this));
        }
        this.register((Object)new MetricRegistryBinder(metricRegistry));
        this.register(new InstrumentedResourceMethodApplicationListener(metricRegistry));
        this.register(CacheControlledResponseFeature.class);
        this.register(OptionalMessageBodyWriter.class);
        this.register(OptionalParamFeature.class);
        this.register(io.dropwizard.jersey.optional.OptionalMessageBodyWriter.class);
        this.register(OptionalDoubleMessageBodyWriter.class);
        this.register(OptionalIntMessageBodyWriter.class);
        this.register(OptionalLongMessageBodyWriter.class);
        this.register(io.dropwizard.jersey.optional.OptionalParamFeature.class);
        this.register(AbstractParamConverterProvider.class);
        this.register(new FuzzyEnumParamConverterProvider());
        this.register((Object)new SessionFactoryProvider.Binder());
    }

    public static DropwizardResourceConfig forTesting(MetricRegistry metricRegistry) {
        return new DropwizardResourceConfig(true, metricRegistry);
    }

    public void logComponents() {
        LOGGER.debug("resources = {}", this.canonicalNamesByAnnotation(Path.class));
        LOGGER.debug("providers = {}", this.canonicalNamesByAnnotation(Provider.class));
        LOGGER.info(this.getEndpointsInfo());
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    @VisibleForTesting
    Set<Class<?>> allClasses() {
        HashSet allClasses = new HashSet(this.getClasses());
        for (Object singleton : this.getSingletons()) {
            allClasses.add(singleton.getClass());
        }
        return allClasses;
    }

    private Set<String> canonicalNamesByAnnotation(Class<? extends Annotation> annotation) {
        HashSet<String> result = new HashSet<String>();
        for (Class clazz : this.getClasses()) {
            if (!clazz.isAnnotationPresent(annotation)) continue;
            result.add(clazz.getCanonicalName());
        }
        return result;
    }

    public String getEndpointsInfo() {
        StringBuilder msg = new StringBuilder(1024);
        TreeSet<EndpointLogLine> endpointLogLines = new TreeSet<EndpointLogLine>(new EndpointComparator());
        msg.append("The following paths were found for the configured resources:");
        msg.append(NEWLINE).append(NEWLINE);
        HashSet allResourcesClasses = new HashSet();
        for (Class<?> clazz : this.allClasses()) {
            if (clazz.isInterface() || Resource.from(clazz) == null) continue;
            allResourcesClasses.add(clazz);
        }
        for (Class<Object> clazz : allResourcesClasses) {
            new EndpointLogger(this.contextPath, this.urlPattern, clazz).populate(endpointLogLines);
        }
        Set allResources = this.getResources();
        for (Resource res : allResources) {
            for (Resource childRes : res.getChildResources()) {
                for (Class childResHandlerClass : childRes.getHandlerClasses()) {
                    EndpointLogger epl = new EndpointLogger(this.contextPath, this.urlPattern, childResHandlerClass);
                    epl.populate(this.cleanUpPath(res.getPath() + epl.rootPath), epl.klass, false, childRes, endpointLogLines);
                }
            }
        }
        if (!endpointLogLines.isEmpty()) {
            for (EndpointLogLine line : endpointLogLines) {
                msg.append(line).append(NEWLINE);
            }
        } else {
            msg.append("    NONE").append(NEWLINE);
        }
        return msg.toString();
    }

    @VisibleForTesting
    String cleanUpPath(String path) {
        return PATH_DIRTY_SLASHES.matcher(path).replaceAll("/").trim();
    }

    static final class MetricRegistryBinder
    extends AbstractBinder {
        private final MetricRegistry metricRegistry;

        public MetricRegistryBinder(MetricRegistry metricRegistry) {
            this.metricRegistry = metricRegistry;
        }

        protected void configure() {
            this.bind(this.metricRegistry).to(MetricRegistry.class);
        }
    }

    private static class ComponentLoggingListener
    implements ApplicationEventListener {
        private final DropwizardResourceConfig config;

        ComponentLoggingListener(DropwizardResourceConfig config) {
            this.config = config;
        }

        public void onEvent(ApplicationEvent event) {
            if (event.getType() == ApplicationEvent.Type.INITIALIZATION_APP_FINISHED) {
                this.config.logComponents();
            }
        }

        @Nullable
        public RequestEventListener onRequest(RequestEvent requestEvent) {
            return null;
        }
    }

    private static class EndpointComparator
    implements Comparator<EndpointLogLine>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private EndpointComparator() {
        }

        @Override
        public int compare(EndpointLogLine endpointA, EndpointLogLine endpointB) {
            return ComparisonChain.start().compare((Comparable)((Object)endpointA.basePath), (Comparable)((Object)endpointB.basePath)).compare((Object)endpointA.httpMethod, (Object)endpointB.httpMethod, Comparator.nullsLast(Ordering.natural())).result();
        }
    }

    private static class EndpointLogLine {
        private final String httpMethod;
        private final String basePath;
        private final Class<?> klass;

        EndpointLogLine(String httpMethod, String basePath, Class<?> klass) {
            this.basePath = basePath;
            this.klass = klass;
            this.httpMethod = httpMethod;
        }

        public String toString() {
            String method = this.httpMethod == null ? "UNKNOWN" : this.httpMethod;
            return String.format("    %-7s %s (%s)", method, this.basePath, this.klass.getCanonicalName());
        }
    }

    private static class EndpointLogger {
        private final String rootPath;
        private final Class<?> klass;

        EndpointLogger(String contextPath, String urlPattern, Class<?> klass) {
            String rootPattern;
            String string = rootPattern = urlPattern.endsWith("/*") ? urlPattern.substring(0, urlPattern.length() - 1) : urlPattern;
            String normalizedContextPath = contextPath.isEmpty() || contextPath.equals("/") ? "" : (contextPath.startsWith("/") ? contextPath : "/" + contextPath);
            this.rootPath = normalizedContextPath + rootPattern;
            this.klass = klass;
        }

        public void populate(Set<EndpointLogLine> endpointLogLines) {
            this.populate(this.rootPath, this.klass, false, endpointLogLines);
        }

        private void populate(String basePath, Class<?> klass, boolean isLocator, Set<EndpointLogLine> endpointLogLines) {
            this.populate(basePath, klass, isLocator, Resource.from(klass), endpointLogLines);
        }

        private void populate(String basePath, Class<?> klass, boolean isLocator, Resource resource, Set<EndpointLogLine> endpointLogLines) {
            if (!isLocator) {
                basePath = EndpointLogger.normalizePath(basePath, resource.getPath());
            }
            for (ResourceMethod method : resource.getResourceMethods()) {
                endpointLogLines.add(new EndpointLogLine(method.getHttpMethod(), basePath, klass));
            }
            for (Resource childResource : resource.getChildResources()) {
                for (ResourceMethod method : childResource.getAllMethods()) {
                    Class erasedType;
                    String path;
                    if (method.getType() == ResourceMethod.JaxrsType.RESOURCE_METHOD) {
                        path = EndpointLogger.normalizePath(basePath, childResource.getPath());
                        endpointLogLines.add(new EndpointLogLine(method.getHttpMethod(), path, klass));
                        continue;
                    }
                    if (method.getType() != ResourceMethod.JaxrsType.SUB_RESOURCE_LOCATOR) continue;
                    path = EndpointLogger.normalizePath(basePath, childResource.getPath());
                    ResolvedType responseType = TYPE_RESOLVER.resolve(method.getInvocable().getResponseType(), new Type[0]);
                    Class clazz = erasedType = !responseType.getTypeBindings().isEmpty() ? responseType.getTypeBindings().getBoundType(0).getErasedType() : responseType.getErasedType();
                    if (Resource.from((Class)erasedType) == null) {
                        endpointLogLines.add(new EndpointLogLine(method.getHttpMethod(), path, erasedType));
                        continue;
                    }
                    this.populate(path, erasedType, true, endpointLogLines);
                }
            }
        }

        private static String normalizePath(String basePath, String path) {
            if (path == null) {
                return basePath;
            }
            if (basePath.endsWith("/")) {
                return path.startsWith("/") ? basePath + path.substring(1) : basePath + path;
            }
            return path.startsWith("/") ? basePath + path : basePath + "/" + path;
        }
    }
}

