/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.configuration;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.error.MarkedYAMLException;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.error.YAMLException;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import io.dropwizard.configuration.ConfigurationException;
import io.dropwizard.configuration.ConfigurationFactory;
import io.dropwizard.configuration.ConfigurationParsingException;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.ConfigurationValidationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.Validator;

public class YamlConfigurationFactory<T>
implements ConfigurationFactory<T> {
    private static final Pattern ESCAPED_COMMA_PATTERN = Pattern.compile("\\\\,");
    private static final Splitter ESCAPED_COMMA_SPLITTER = Splitter.on((Pattern)Pattern.compile("(?<!\\\\),")).trimResults();
    private static final Splitter DOT_SPLITTER = Splitter.on((char)'.').trimResults();
    private final Class<T> klass;
    private final String propertyPrefix;
    private final ObjectMapper mapper;
    private final Validator validator;
    private final YAMLFactory yamlFactory;

    public YamlConfigurationFactory(Class<T> klass, Validator validator, ObjectMapper objectMapper, String propertyPrefix) {
        this.klass = klass;
        String string = this.propertyPrefix = propertyPrefix == null || propertyPrefix.endsWith(".") ? propertyPrefix : propertyPrefix + '.';
        if (objectMapper == null) {
            this.mapper = null;
            this.yamlFactory = null;
        } else {
            this.mapper = objectMapper.copy().enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            this.yamlFactory = new YAMLFactory();
        }
        this.validator = validator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T build(ConfigurationSourceProvider provider, String path) throws IOException, ConfigurationException {
        try (InputStream input = provider.open(Objects.requireNonNull(path));){
            JsonNode node = (JsonNode)this.mapper.readTree((JsonParser)this.yamlFactory.createParser(input));
            if (node == null) {
                throw ConfigurationParsingException.builder("Configuration at " + path + " must not be empty").build(path);
            }
            T t = this.build(node, path);
            return t;
        }
        catch (YAMLException e) {
            ConfigurationParsingException.Builder builder = ConfigurationParsingException.builder("Malformed YAML").setCause((Exception)((Object)e)).setDetail(e.getMessage());
            if (!(e instanceof MarkedYAMLException)) throw builder.build(path);
            builder.setLocation(((MarkedYAMLException)e).getProblemMark());
            throw builder.build(path);
        }
    }

    @Override
    public T build() throws IOException, ConfigurationException {
        try {
            JsonNode node = this.mapper.valueToTree(this.klass.newInstance());
            return this.build(node, "default configuration");
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Unable create an instance of the configuration class: '" + this.klass.getCanonicalName() + "'", e);
        }
    }

    protected T build(JsonNode node, String path) throws IOException, ConfigurationException {
        for (Map.Entry<Object, Object> pref : System.getProperties().entrySet()) {
            String prefName = (String)pref.getKey();
            if (!prefName.startsWith(this.propertyPrefix)) continue;
            String configName = prefName.substring(this.propertyPrefix.length());
            this.addOverride(node, configName, System.getProperty(prefName));
        }
        try {
            Object config = this.mapper.readValue((JsonParser)new TreeTraversingParser(node), this.klass);
            this.validate(path, config);
            return (T)config;
        }
        catch (UnrecognizedPropertyException e) {
            List<String> properties = e.getKnownPropertyIds().stream().map(Object::toString).collect(Collectors.toList());
            throw ConfigurationParsingException.builder("Unrecognized field").setFieldPath(e.getPath()).setLocation(e.getLocation()).addSuggestions(properties).setSuggestionBase(e.getPropertyName()).setCause((Exception)((Object)e)).build(path);
        }
        catch (InvalidFormatException e) {
            String sourceType = e.getValue().getClass().getSimpleName();
            String targetType = e.getTargetType().getSimpleName();
            throw ConfigurationParsingException.builder("Incorrect type of value").setDetail("is of type: " + sourceType + ", expected: " + targetType).setLocation(e.getLocation()).setFieldPath(e.getPath()).setCause((Exception)((Object)e)).build(path);
        }
        catch (JsonMappingException e) {
            throw ConfigurationParsingException.builder("Failed to parse configuration").setDetail(e.getMessage()).setFieldPath(e.getPath()).setLocation(e.getLocation()).setCause((Exception)((Object)e)).build(path);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void addOverride(JsonNode root, String name, String value) {
        JsonNode node = root;
        String[] parts = (String[])Iterables.toArray((Iterable)DOT_SPLITTER.split((CharSequence)name), String.class);
        int i = 0;
        while (i < parts.length) {
            JsonNode child;
            boolean moreParts;
            String key = parts[i];
            if (!(node instanceof ObjectNode)) {
                throw new IllegalArgumentException("Unable to override " + name + "; it's not a valid path.");
            }
            ObjectNode obj = (ObjectNode)node;
            String remainingPath = Joiner.on((char)'.').join((Object[])Arrays.copyOfRange(parts, i, parts.length));
            if (obj.has(remainingPath) && !remainingPath.equals(key) && obj.get(remainingPath).isValueNode()) {
                obj.put(remainingPath, value);
                return;
            }
            boolean bl = moreParts = i < parts.length - 1;
            if (key.matches(".+\\[\\d+\\]$")) {
                int s = key.indexOf(91);
                int index = Integer.parseInt(key.substring(s + 1, key.length() - 1));
                child = obj.get(key.substring(0, s));
                if (child == null) {
                    throw new IllegalArgumentException("Unable to override " + name + "; node with index not found.");
                }
                if (!child.isArray()) {
                    throw new IllegalArgumentException("Unable to override " + name + "; node with index is not an array.");
                }
                if (index >= child.size()) {
                    throw new ArrayIndexOutOfBoundsException("Unable to override " + name + "; index is greater than size of array.");
                }
                if (!moreParts) {
                    ArrayNode array = (ArrayNode)child;
                    array.set(index, (JsonNode)TextNode.valueOf((String)value));
                    return;
                }
                node = child = child.get(index);
            } else if (moreParts) {
                child = obj.get(key);
                if (child == null) {
                    child = obj.objectNode();
                    obj.set(key, child);
                }
                if (child.isArray()) {
                    throw new IllegalArgumentException("Unable to override " + name + "; target is an array but no index specified");
                }
                node = child;
            }
            if (!moreParts) {
                if (node.get(key) != null && node.get(key).isArray()) {
                    ArrayNode arrayNode = (ArrayNode)obj.get(key);
                    arrayNode.removeAll();
                    for (String val : ESCAPED_COMMA_SPLITTER.split((CharSequence)value)) {
                        arrayNode.add(ESCAPED_COMMA_PATTERN.matcher(val).replaceAll(","));
                    }
                } else {
                    obj.put(key, value);
                }
            }
            ++i;
        }
        return;
    }

    private void validate(String path, T config) throws ConfigurationValidationException {
        Set violations;
        if (this.validator != null && !(violations = this.validator.validate(config, new Class[0])).isEmpty()) {
            throw new ConfigurationValidationException(path, violations);
        }
    }
}

