/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.types;

import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.types.DataType;
import java.util.Objects;

@Evolving
public final class DecimalType
extends DataType {
    public static final DecimalType USER_DEFAULT = new DecimalType(10, 0);
    private final int precision;
    private final int scale;

    public DecimalType(int n, int n2) {
        if (n < 0 || n > 38 || n2 < 0 || n2 > 38 || n2 > n) {
            throw new IllegalArgumentException(String.format("Invalid precision and scale combo (%d, %d). They should be in the range [0, 38] and scale can not be more than the precision.", n, n2));
        }
        this.precision = n;
        this.scale = n2;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public String toJson() {
        return String.format("\"decimal(%d, %d)\"", this.precision, this.scale);
    }

    @Override
    public String toString() {
        return String.format("Decimal(%d, %d)", this.precision, this.scale);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DecimalType decimalType = (DecimalType)object;
        return this.precision == decimalType.precision && this.scale == decimalType.scale;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.precision, this.scale);
    }
}

