/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import java.io.IOException;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.BulkBucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.DeltaBulkPartWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.util.Preconditions;

public class DeltaBulkBucketWriter<IN, BucketID>
extends BulkBucketWriter<IN, BucketID> {
    private final BulkWriter.Factory<IN> writerFactory;

    public DeltaBulkBucketWriter(RecoverableWriter recoverableWriter, BulkWriter.Factory<IN> factory) throws IOException {
        super(recoverableWriter, factory);
        this.writerFactory = factory;
    }

    public InProgressFileWriter<IN, BucketID> resumeFrom(BucketID BucketID, RecoverableFsDataOutputStream recoverableFsDataOutputStream, Path path, RecoverableWriter.ResumeRecoverable resumeRecoverable, long l) throws IOException {
        Preconditions.checkNotNull((Object)recoverableFsDataOutputStream);
        Preconditions.checkNotNull((Object)resumeRecoverable);
        BulkWriter bulkWriter = this.writerFactory.create((FSDataOutputStream)recoverableFsDataOutputStream);
        return new DeltaBulkPartWriter(BucketID, recoverableFsDataOutputStream, bulkWriter, l);
    }

    public DeltaBulkPartWriter<IN, BucketID> openNew(BucketID BucketID, RecoverableFsDataOutputStream recoverableFsDataOutputStream, Path path, long l) throws IOException {
        Preconditions.checkNotNull((Object)recoverableFsDataOutputStream);
        Preconditions.checkNotNull((Object)path);
        BulkWriter bulkWriter = this.writerFactory.create((FSDataOutputStream)recoverableFsDataOutputStream);
        return new DeltaBulkPartWriter(BucketID, recoverableFsDataOutputStream, bulkWriter, l);
    }
}

