/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal.utils;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;

public class TransitiveOptional<T> {
    private static final TransitiveOptional<?> EMPTY = new TransitiveOptional();
    private final T value;

    private TransitiveOptional() {
        this.value = null;
    }

    private TransitiveOptional(T t) {
        Objects.requireNonNull(t);
        this.value = t;
    }

    public static <T> TransitiveOptional<T> of(T t) {
        return new TransitiveOptional<T>(t);
    }

    public static <T> TransitiveOptional<T> ofNullable(T t) {
        return t == null ? TransitiveOptional.empty() : TransitiveOptional.of(t);
    }

    public static <T> TransitiveOptional<T> empty() {
        TransitiveOptional<?> transitiveOptional = EMPTY;
        return transitiveOptional;
    }

    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public TransitiveOptional<T> or(Supplier<? extends TransitiveOptional<? extends T>> supplier) {
        Objects.requireNonNull(supplier);
        if (this.value != null) {
            return this;
        }
        TransitiveOptional<? extends T> transitiveOptional = supplier.get();
        return Objects.requireNonNull(transitiveOptional);
    }
}

