/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal.utils;

import io.delta.flink.source.internal.SchemaConverter;
import io.delta.standalone.Snapshot;
import io.delta.standalone.actions.Metadata;
import io.delta.standalone.types.StructField;
import io.delta.standalone.types.StructType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.table.types.logical.LogicalType;

public class SourceSchema {
    private final String[] columnNames;
    private final LogicalType[] columnTypes;
    private final long snapshotVersion;
    private final List<String> partitionColumns;

    private SourceSchema(String[] stringArray, LogicalType[] logicalTypeArray, long l, Collection<String> collection) {
        this.columnNames = stringArray;
        this.columnTypes = logicalTypeArray;
        this.snapshotVersion = l;
        this.partitionColumns = new ArrayList<String>(collection);
    }

    public static SourceSchema fromSnapshot(Collection<String> collection, Snapshot snapshot) {
        String[] stringArray;
        LogicalType[] logicalTypeArray;
        Metadata metadata = snapshot.getMetadata();
        StructType structType = metadata.getSchema();
        if (structType == null) {
            throw new IllegalArgumentException(String.format("Unable to find Schema information in Delta log for Snapshot version [%d]", snapshot.getVersion()));
        }
        if (collection != null && !collection.isEmpty()) {
            logicalTypeArray = new LogicalType[collection.size()];
            int n = 0;
            for (String string : collection) {
                StructField structField = structType.get(string);
                logicalTypeArray[n++] = SchemaConverter.toFlinkDataType(structField.getDataType(), structField.isNullable());
            }
            stringArray = collection.toArray(new String[0]);
        } else {
            StructField[] structFieldArray = structType.getFields();
            stringArray = new String[structFieldArray.length];
            logicalTypeArray = new LogicalType[structFieldArray.length];
            int n = 0;
            for (StructField structField : structFieldArray) {
                stringArray[n] = structField.getName();
                logicalTypeArray[n] = SchemaConverter.toFlinkDataType(structField.getDataType(), structField.isNullable());
                ++n;
            }
        }
        return new SourceSchema(stringArray, logicalTypeArray, snapshot.getVersion(), metadata.getPartitionColumns());
    }

    public List<String> getPartitionColumns() {
        return Collections.unmodifiableList(this.partitionColumns);
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public LogicalType[] getColumnTypes() {
        return this.columnTypes;
    }

    public long getSnapshotVersion() {
        return this.snapshotVersion;
    }
}

