/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal.state;

import io.delta.flink.source.internal.state.DeltaEnumeratorStateCheckpoint;
import io.delta.flink.source.internal.state.DeltaSourceSplit;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.connector.file.src.PendingSplitsCheckpoint;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.Preconditions;

public class DeltaEnumeratorStateCheckpointBuilder<SplitT extends DeltaSourceSplit> {
    private final Path deltaTablePath;
    private final long snapshotVersion;
    private final Collection<SplitT> splits;
    private Collection<Path> processedPaths = Collections.emptySet();
    private boolean monitoringForChanges;

    public DeltaEnumeratorStateCheckpointBuilder(Path path, long l, Collection<SplitT> collection) {
        this.deltaTablePath = path;
        this.snapshotVersion = l;
        this.splits = collection;
        this.monitoringForChanges = false;
    }

    public static <T extends DeltaSourceSplit> DeltaEnumeratorStateCheckpointBuilder<T> builder(Path path, long l, Collection<T> collection) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)l);
        return new DeltaEnumeratorStateCheckpointBuilder<T>(path, l, collection);
    }

    public DeltaEnumeratorStateCheckpointBuilder<SplitT> withProcessedPaths(Collection<Path> collection) {
        this.processedPaths = collection;
        return this;
    }

    public DeltaEnumeratorStateCheckpointBuilder<SplitT> withMonitoringForChanges(boolean bl) {
        this.monitoringForChanges = bl;
        return this;
    }

    public DeltaEnumeratorStateCheckpoint<SplitT> build() {
        PendingSplitsCheckpoint pendingSplitsCheckpoint = PendingSplitsCheckpoint.fromCollectionSnapshot(this.splits, this.processedPaths);
        return new DeltaEnumeratorStateCheckpoint(this.deltaTablePath, this.snapshotVersion, this.monitoringForChanges, pendingSplitsCheckpoint);
    }
}

