/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal.enumerator.processor;

import io.delta.flink.source.internal.enumerator.monitor.ChangesPerVersion;
import io.delta.flink.source.internal.enumerator.processor.TableProcessor;
import io.delta.flink.source.internal.file.AddFileEnumerator;
import io.delta.flink.source.internal.file.AddFileEnumeratorContext;
import io.delta.flink.source.internal.state.DeltaSourceSplit;
import io.delta.flink.source.internal.utils.SourceUtils;
import io.delta.standalone.actions.AddFile;
import java.util.List;
import org.apache.flink.core.fs.Path;

public abstract class TableProcessorBase
implements TableProcessor {
    protected final Path deltaTablePath;
    protected final AddFileEnumerator<DeltaSourceSplit> fileEnumerator;

    public TableProcessorBase(Path path, AddFileEnumerator<DeltaSourceSplit> addFileEnumerator) {
        this.deltaTablePath = path;
        this.fileEnumerator = addFileEnumerator;
    }

    protected AddFileEnumeratorContext setUpEnumeratorContext(List<AddFile> list, long l) {
        String string = SourceUtils.pathToString(this.deltaTablePath);
        return new AddFileEnumeratorContext(string, list, l);
    }

    protected List<DeltaSourceSplit> prepareSplits(ChangesPerVersion<AddFile> changesPerVersion, AddFileEnumerator.SplitFilter<Path> splitFilter) {
        AddFileEnumeratorContext addFileEnumeratorContext = this.setUpEnumeratorContext(changesPerVersion.getChanges(), changesPerVersion.getSnapshotVersion());
        return this.fileEnumerator.enumerateSplits(addFileEnumeratorContext, splitFilter);
    }
}

