/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal.enumerator.processor;

import io.delta.standalone.actions.Action;
import io.delta.standalone.actions.AddFile;
import io.delta.standalone.actions.Metadata;
import io.delta.standalone.actions.Protocol;
import io.delta.standalone.actions.RemoveFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

enum DeltaAction {
    ADD(AddFile.class),
    REMOVE(RemoveFile.class),
    METADATA(Metadata.class),
    PROTOCOL(Protocol.class),
    OTHER(null);

    private static final Map<Class<?>, DeltaAction> LOOKUP_MAP;
    private final Class<?> deltaActionClass;

    private DeltaAction(Class<?> clazz) {
        this.deltaActionClass = clazz;
    }

    public static DeltaAction instanceFrom(Class<? extends Action> clazz) {
        return LOOKUP_MAP.getOrDefault(clazz, OTHER);
    }

    static {
        HashMap hashMap = new HashMap();
        for (DeltaAction deltaAction : DeltaAction.values()) {
            hashMap.put(deltaAction.deltaActionClass, deltaAction);
        }
        LOOKUP_MAP = Collections.unmodifiableMap(hashMap);
    }
}

