/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal.enumerator.processor;

import io.delta.flink.source.internal.enumerator.monitor.ChangesPerVersion;
import io.delta.flink.source.internal.enumerator.processor.DeltaAction;
import io.delta.flink.source.internal.exceptions.DeltaSourceExceptions;
import io.delta.standalone.actions.Action;
import io.delta.standalone.actions.AddFile;
import io.delta.standalone.actions.RemoveFile;
import java.util.ArrayList;

public class ActionProcessor {
    private final boolean ignoreDeletes;
    private final boolean ignoreChanges;

    public ActionProcessor(boolean bl, boolean bl2) {
        this.ignoreChanges = bl;
        this.ignoreDeletes = bl2 || bl;
    }

    public ChangesPerVersion<AddFile> processActions(ChangesPerVersion<Action> changesPerVersion) {
        ArrayList<AddFile> arrayList = new ArrayList<AddFile>(changesPerVersion.size());
        boolean bl = false;
        boolean bl2 = false;
        for (Action action : changesPerVersion.getChanges()) {
            DeltaAction deltaAction = DeltaAction.instanceFrom(action.getClass());
            switch (deltaAction) {
                case ADD: {
                    if (!((AddFile)action).isDataChange()) break;
                    bl = true;
                    arrayList.add((AddFile)action);
                    break;
                }
                case REMOVE: {
                    if (!((RemoveFile)action).isDataChange()) break;
                    bl2 = true;
                    break;
                }
                case METADATA: 
                case PROTOCOL: {
                    throw DeltaSourceExceptions.unsupportedDeltaActionException(changesPerVersion.getDeltaTablePath(), changesPerVersion.getSnapshotVersion(), action);
                }
            }
            this.actionsSanityCheck(bl, bl2, changesPerVersion);
        }
        return new ChangesPerVersion<AddFile>(changesPerVersion.getDeltaTablePath(), changesPerVersion.getSnapshotVersion(), arrayList);
    }

    private void actionsSanityCheck(boolean bl, boolean bl2, ChangesPerVersion<Action> changesPerVersion) {
        if (bl2) {
            if (bl && !this.ignoreChanges) {
                throw DeltaSourceExceptions.deltaSourceIgnoreChangesException(changesPerVersion.getDeltaTablePath(), changesPerVersion.getSnapshotVersion());
            }
            if (!bl && !this.ignoreDeletes) {
                throw DeltaSourceExceptions.deltaSourceIgnoreDeleteException(changesPerVersion.getDeltaTablePath(), changesPerVersion.getSnapshotVersion());
            }
        }
    }
}

