/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal.builder;

import io.delta.flink.source.internal.state.DeltaSourceSplit;
import java.io.Serializable;
import java.util.List;
import org.apache.flink.connector.file.table.PartitionFieldExtractor;
import org.apache.flink.formats.parquet.vector.ColumnBatchFactory;
import org.apache.flink.formats.parquet.vector.ParquetSplitReaderUtil;
import org.apache.flink.table.data.columnar.vector.ColumnVector;
import org.apache.flink.table.data.columnar.vector.VectorizedColumnBatch;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public final class RowBuilderUtils {
    private RowBuilderUtils() {
    }

    public static <SplitT extends DeltaSourceSplit> ColumnBatchFactory<SplitT> createPartitionedColumnFactory(RowType rowType, List<String> list, List<String> list2, PartitionFieldExtractor<SplitT> partitionFieldExtractor, int n) {
        return (ColumnBatchFactory & Serializable)(deltaSourceSplit, columnVectorArray) -> {
            ColumnVector[] columnVectorArray2 = new ColumnVector[rowType.getFieldCount()];
            for (int i = 0; i < columnVectorArray2.length; ++i) {
                RowType.RowField rowField = (RowType.RowField)rowType.getFields().get(i);
                columnVectorArray2[i] = list2.contains(rowField.getName()) ? ParquetSplitReaderUtil.createVectorFromConstant((LogicalType)rowField.getType(), (Object)partitionFieldExtractor.extract(deltaSourceSplit, rowField.getName(), rowField.getType()), (int)n) : columnVectorArray[list.indexOf(rowField.getName())];
            }
            return new VectorizedColumnBatch(columnVectorArray2);
        };
    }
}

