/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal.builder;

import io.delta.flink.source.internal.DeltaSourceOptions;
import io.delta.flink.source.internal.builder.DeltaSourceBuilderBase;
import io.delta.flink.source.internal.builder.Validator;
import io.delta.flink.source.internal.enumerator.ContinuousSplitEnumeratorProvider;
import io.delta.flink.source.internal.enumerator.supplier.ContinuousSnapshotSupplierFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.core.fs.Path;
import org.apache.hadoop.conf.Configuration;

public abstract class ContinuousDeltaSourceBuilder<T, SELF>
extends DeltaSourceBuilderBase<T, SELF> {
    protected static final ContinuousSplitEnumeratorProvider DEFAULT_CONTINUOUS_SPLIT_ENUMERATOR_PROVIDER = new ContinuousSplitEnumeratorProvider(DEFAULT_SPLIT_ASSIGNER, DEFAULT_SPLITTABLE_FILE_ENUMERATOR);
    protected static final List<String> APPLICABLE_OPTIONS = Collections.unmodifiableList(Arrays.asList(DeltaSourceOptions.STARTING_VERSION.key(), DeltaSourceOptions.STARTING_TIMESTAMP.key(), DeltaSourceOptions.IGNORE_CHANGES.key(), DeltaSourceOptions.IGNORE_DELETES.key(), DeltaSourceOptions.UPDATE_CHECK_INTERVAL.key(), DeltaSourceOptions.UPDATE_CHECK_INITIAL_DELAY.key(), DeltaSourceOptions.PARQUET_BATCH_SIZE.key()));

    public ContinuousDeltaSourceBuilder(Path path, Configuration configuration, ContinuousSnapshotSupplierFactory continuousSnapshotSupplierFactory) {
        super(path, configuration, continuousSnapshotSupplierFactory);
    }

    public SELF startingVersion(String string) {
        this.option(DeltaSourceOptions.STARTING_VERSION.key(), string);
        return this.self();
    }

    public SELF startingVersion(long l) {
        this.option(DeltaSourceOptions.STARTING_VERSION.key(), l);
        return this.self();
    }

    public SELF startingTimestamp(String string) {
        this.option(DeltaSourceOptions.STARTING_TIMESTAMP.key(), string);
        return this.self();
    }

    public SELF updateCheckIntervalMillis(long l) {
        this.option(DeltaSourceOptions.UPDATE_CHECK_INTERVAL.key(), l);
        return this.self();
    }

    public SELF ignoreDeletes(boolean bl) {
        this.option(DeltaSourceOptions.IGNORE_DELETES.key(), bl);
        return this.self();
    }

    public SELF ignoreChanges(boolean bl) {
        this.option(DeltaSourceOptions.IGNORE_CHANGES.key(), bl);
        return this.self();
    }

    @Override
    protected Validator validateOptionExclusions() {
        return new Validator().checkArgument(!this.sourceConfiguration.hasOption(DeltaSourceOptions.STARTING_TIMESTAMP) || !this.sourceConfiguration.hasOption(DeltaSourceOptions.STARTING_VERSION), this.prepareOptionExclusionMessage(DeltaSourceOptions.STARTING_VERSION.key(), DeltaSourceOptions.STARTING_TIMESTAMP.key()));
    }

    @Override
    protected Collection<String> getApplicableOptions() {
        return APPLICABLE_OPTIONS;
    }
}

