/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal.builder;

import io.delta.flink.source.internal.DeltaSourceOptions;
import io.delta.flink.source.internal.builder.DeltaSourceBuilderBase;
import io.delta.flink.source.internal.builder.Validator;
import io.delta.flink.source.internal.enumerator.BoundedSplitEnumeratorProvider;
import io.delta.flink.source.internal.enumerator.supplier.BoundedSnapshotSupplierFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.core.fs.Path;
import org.apache.hadoop.conf.Configuration;

public abstract class BoundedDeltaSourceBuilder<T, SELF>
extends DeltaSourceBuilderBase<T, SELF> {
    protected static final BoundedSplitEnumeratorProvider DEFAULT_BOUNDED_SPLIT_ENUMERATOR_PROVIDER = new BoundedSplitEnumeratorProvider(DEFAULT_SPLIT_ASSIGNER, DEFAULT_SPLITTABLE_FILE_ENUMERATOR);
    protected static final List<String> APPLICABLE_OPTIONS = Collections.unmodifiableList(Arrays.asList(DeltaSourceOptions.VERSION_AS_OF.key(), DeltaSourceOptions.TIMESTAMP_AS_OF.key(), DeltaSourceOptions.PARQUET_BATCH_SIZE.key()));

    public BoundedDeltaSourceBuilder(Path path, Configuration configuration, BoundedSnapshotSupplierFactory boundedSnapshotSupplierFactory) {
        super(path, configuration, boundedSnapshotSupplierFactory);
    }

    public SELF versionAsOf(long l) {
        this.option(DeltaSourceOptions.VERSION_AS_OF.key(), l);
        return this.self();
    }

    public SELF timestampAsOf(String string) {
        this.option(DeltaSourceOptions.TIMESTAMP_AS_OF.key(), string);
        return this.self();
    }

    @Override
    protected Validator validateOptionExclusions() {
        return new Validator().checkArgument(!this.sourceConfiguration.hasOption(DeltaSourceOptions.VERSION_AS_OF) || !this.sourceConfiguration.hasOption(DeltaSourceOptions.TIMESTAMP_AS_OF), this.prepareOptionExclusionMessage(DeltaSourceOptions.VERSION_AS_OF.key(), DeltaSourceOptions.TIMESTAMP_AS_OF.key()));
    }

    @Override
    protected Collection<String> getApplicableOptions() {
        return APPLICABLE_OPTIONS;
    }
}

