/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal;

import io.delta.flink.source.internal.DeltaDataType;
import io.delta.standalone.types.DataType;
import io.delta.standalone.types.DecimalType;
import io.delta.standalone.types.StructField;
import io.delta.standalone.types.StructType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarCharType;

public class SchemaConverter {
    private static RowType toRowType(StructType structType, boolean bl) {
        StructField[] structFieldArray = structType.getFields();
        String[] stringArray = new String[structFieldArray.length];
        LogicalType[] logicalTypeArray = new LogicalType[structFieldArray.length];
        for (int i = 0; i < structFieldArray.length; ++i) {
            StructField structField = structFieldArray[i];
            stringArray[i] = structField.getName();
            logicalTypeArray[i] = SchemaConverter.toFlinkDataType(structField.getDataType(), structField.isNullable());
        }
        return RowType.of((boolean)bl, (LogicalType[])logicalTypeArray, (String[])stringArray);
    }

    public static LogicalType toFlinkDataType(DataType dataType, boolean bl) {
        DeltaDataType deltaDataType = DeltaDataType.instanceFrom(dataType.getClass());
        switch (deltaDataType) {
            case ARRAY: {
                boolean bl2 = ((io.delta.standalone.types.ArrayType)dataType).containsNull();
                LogicalType logicalType = SchemaConverter.toFlinkDataType(((io.delta.standalone.types.ArrayType)dataType).getElementType(), bl2);
                return new ArrayType(bl, logicalType);
            }
            case LONG: {
                return new BigIntType(bl);
            }
            case BINARY: {
                return new BinaryType(bl, 1);
            }
            case BOOLEAN: {
                return new BooleanType(bl);
            }
            case BYTE: 
            case TINYINT: {
                return new TinyIntType(bl);
            }
            case DATE: {
                return new DateType(bl);
            }
            case DECIMAL: {
                int n = ((DecimalType)dataType).getPrecision();
                int n2 = ((DecimalType)dataType).getScale();
                return new org.apache.flink.table.types.logical.DecimalType(bl, n, n2);
            }
            case DOUBLE: {
                return new DoubleType(bl);
            }
            case FLOAT: {
                return new FloatType(bl);
            }
            case INTEGER: {
                return new IntType(bl);
            }
            case MAP: {
                boolean bl3 = ((io.delta.standalone.types.MapType)dataType).valueContainsNull();
                LogicalType logicalType = SchemaConverter.toFlinkDataType(((io.delta.standalone.types.MapType)dataType).getKeyType(), bl3);
                LogicalType logicalType2 = SchemaConverter.toFlinkDataType(((io.delta.standalone.types.MapType)dataType).getValueType(), bl3);
                return new MapType(bl, logicalType, logicalType2);
            }
            case NULL: {
                return new NullType();
            }
            case SMALLINT: {
                return new SmallIntType(bl);
            }
            case TIMESTAMP: {
                return new TimestampType(bl, 6);
            }
            case STRING: {
                return new VarCharType(bl, Integer.MAX_VALUE);
            }
            case STRUCT: {
                return SchemaConverter.toRowType((StructType)dataType, bl);
            }
        }
        throw new UnsupportedOperationException("Type not supported: " + (Object)((Object)deltaDataType));
    }
}

