/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal;

import io.delta.flink.internal.options.DeltaConnectorConfiguration;
import io.delta.flink.source.internal.enumerator.SplitEnumeratorProvider;
import io.delta.flink.source.internal.state.DeltaEnumeratorStateCheckpoint;
import io.delta.flink.source.internal.state.DeltaPendingSplitsCheckpointSerializer;
import io.delta.flink.source.internal.state.DeltaSourceSplit;
import io.delta.flink.source.internal.state.DeltaSourceSplitSerializer;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.connector.file.src.impl.FileSourceReader;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.formats.parquet.utils.SerializableConfiguration;
import org.apache.hadoop.conf.Configuration;

public class DeltaSourceInternal<T>
implements Source<T, DeltaSourceSplit, DeltaEnumeratorStateCheckpoint<DeltaSourceSplit>>,
ResultTypeQueryable<T> {
    private static final long serialVersionUID = 1L;
    private final Path tablePath;
    private final BulkFormat<T, DeltaSourceSplit> readerFormat;
    private final SplitEnumeratorProvider splitEnumeratorProvider;
    private final SerializableConfiguration serializableConf;
    private final DeltaConnectorConfiguration sourceConfiguration;

    protected DeltaSourceInternal(Path path, BulkFormat<T, DeltaSourceSplit> bulkFormat, SplitEnumeratorProvider splitEnumeratorProvider, Configuration configuration, DeltaConnectorConfiguration deltaConnectorConfiguration) {
        this.tablePath = path;
        this.readerFormat = bulkFormat;
        this.splitEnumeratorProvider = splitEnumeratorProvider;
        this.serializableConf = new SerializableConfiguration(configuration);
        this.sourceConfiguration = deltaConnectorConfiguration;
    }

    public SimpleVersionedSerializer<DeltaSourceSplit> getSplitSerializer() {
        return DeltaSourceSplitSerializer.INSTANCE;
    }

    public SimpleVersionedSerializer<DeltaEnumeratorStateCheckpoint<DeltaSourceSplit>> getEnumeratorCheckpointSerializer() {
        return new DeltaPendingSplitsCheckpointSerializer<DeltaSourceSplit>(DeltaSourceSplitSerializer.INSTANCE);
    }

    public Boundedness getBoundedness() {
        return this.splitEnumeratorProvider.getBoundedness();
    }

    public SourceReader<T, DeltaSourceSplit> createReader(SourceReaderContext sourceReaderContext) throws Exception {
        return new FileSourceReader(sourceReaderContext, this.readerFormat, sourceReaderContext.getConfiguration());
    }

    public SplitEnumerator<DeltaSourceSplit, DeltaEnumeratorStateCheckpoint<DeltaSourceSplit>> createEnumerator(SplitEnumeratorContext<DeltaSourceSplit> splitEnumeratorContext) {
        return this.splitEnumeratorProvider.createInitialStateEnumerator(this.tablePath, this.serializableConf.conf(), splitEnumeratorContext, this.sourceConfiguration);
    }

    public SplitEnumerator<DeltaSourceSplit, DeltaEnumeratorStateCheckpoint<DeltaSourceSplit>> restoreEnumerator(SplitEnumeratorContext<DeltaSourceSplit> splitEnumeratorContext, DeltaEnumeratorStateCheckpoint<DeltaSourceSplit> deltaEnumeratorStateCheckpoint) throws Exception {
        return this.splitEnumeratorProvider.createEnumeratorForCheckpoint(deltaEnumeratorStateCheckpoint, this.serializableConf.conf(), splitEnumeratorContext, this.sourceConfiguration);
    }

    public TypeInformation<T> getProducedType() {
        return this.readerFormat.getProducedType();
    }

    @VisibleForTesting
    public Path getTablePath() {
        return this.tablePath;
    }

    @VisibleForTesting
    public DeltaConnectorConfiguration getSourceConfiguration() {
        return this.sourceConfiguration;
    }
}

