/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal;

import io.delta.flink.source.internal.exceptions.DeltaSourceExceptions;
import io.delta.flink.source.internal.state.DeltaSourceSplit;
import java.util.Map;
import org.apache.flink.connector.file.table.PartitionFieldExtractor;
import org.apache.flink.connector.file.table.RowPartitionComputer;
import org.apache.flink.table.types.logical.LogicalType;

public class DeltaPartitionFieldExtractor<SplitT extends DeltaSourceSplit>
implements PartitionFieldExtractor<SplitT> {
    public Object extract(SplitT SplitT, String string, LogicalType logicalType) {
        Map<String, String> map = ((DeltaSourceSplit)((Object)SplitT)).getPartitionValues();
        this.sanityCheck(string, map);
        return RowPartitionComputer.restorePartValueFromType((String)map.get(string), (LogicalType)logicalType);
    }

    private void sanityCheck(String string, Map<String, String> map) {
        if (this.tableHasNoPartitions(map)) {
            throw DeltaSourceExceptions.notPartitionedTableException(string);
        }
        if (this.isNotAPartitionColumn(string, map)) {
            throw DeltaSourceExceptions.missingPartitionValueException(string, map.keySet());
        }
    }

    private boolean tableHasNoPartitions(Map<String, String> map) {
        return map == null || map.isEmpty();
    }

    private boolean isNotAPartitionColumn(String string, Map<String, String> map) {
        return !map.containsKey(string);
    }
}

