/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source;

import io.delta.flink.source.DeltaSource;
import io.delta.flink.source.internal.DeltaSourceOptions;
import io.delta.flink.source.internal.builder.BoundedDeltaSourceBuilder;
import io.delta.flink.source.internal.builder.RowDataFormat;
import io.delta.flink.source.internal.builder.RowDataFormatBuilder;
import io.delta.flink.source.internal.enumerator.supplier.BoundedSnapshotSupplierFactory;
import io.delta.flink.source.internal.utils.SourceSchema;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.conf.Configuration;

public class RowDataBoundedDeltaSourceBuilder
extends BoundedDeltaSourceBuilder<RowData, RowDataBoundedDeltaSourceBuilder> {
    RowDataBoundedDeltaSourceBuilder(Path path, Configuration configuration, BoundedSnapshotSupplierFactory boundedSnapshotSupplierFactory) {
        super(path, configuration, boundedSnapshotSupplierFactory);
    }

    @Override
    public RowDataBoundedDeltaSourceBuilder columnNames(List<String> list) {
        return (RowDataBoundedDeltaSourceBuilder)super.columnNames(list);
    }

    public RowDataBoundedDeltaSourceBuilder columnNames(String ... stringArray) {
        return (RowDataBoundedDeltaSourceBuilder)super.columnNames(Arrays.asList(stringArray));
    }

    @Override
    public RowDataBoundedDeltaSourceBuilder versionAsOf(long l) {
        return (RowDataBoundedDeltaSourceBuilder)super.versionAsOf(l);
    }

    @Override
    public RowDataBoundedDeltaSourceBuilder timestampAsOf(String string) {
        return (RowDataBoundedDeltaSourceBuilder)super.timestampAsOf(string);
    }

    @Override
    public RowDataBoundedDeltaSourceBuilder option(String string, String string2) {
        return (RowDataBoundedDeltaSourceBuilder)super.option(string, string2);
    }

    @Override
    public RowDataBoundedDeltaSourceBuilder option(String string, boolean bl) {
        return (RowDataBoundedDeltaSourceBuilder)super.option(string, bl);
    }

    @Override
    public RowDataBoundedDeltaSourceBuilder option(String string, int n) {
        return (RowDataBoundedDeltaSourceBuilder)super.option(string, n);
    }

    @Override
    public RowDataBoundedDeltaSourceBuilder option(String string, long l) {
        return (RowDataBoundedDeltaSourceBuilder)super.option(string, l);
    }

    @Override
    public DeltaSource<RowData> build() {
        this.validate();
        SourceSchema sourceSchema = this.getSourceSchema();
        this.sourceConfiguration.addOption(DeltaSourceOptions.LOADED_SCHEMA_SNAPSHOT_VERSION, sourceSchema.getSnapshotVersion());
        RowDataFormat rowDataFormat = ((RowDataFormatBuilder)RowDataFormat.builder(RowType.of((LogicalType[])sourceSchema.getColumnTypes(), (String[])sourceSchema.getColumnNames()), this.hadoopConfiguration).partitionColumns((List)sourceSchema.getPartitionColumns())).build();
        return new DeltaSource<RowData>(this.tablePath, rowDataFormat, DEFAULT_BOUNDED_SPLIT_ENUMERATOR_PROVIDER, this.hadoopConfiguration, this.sourceConfiguration);
    }
}

