/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.sink.internal.committables;

import io.delta.flink.sink.internal.committables.DeltaCommittable;
import io.delta.flink.sink.internal.committables.DeltaCommittableSerializer;
import io.delta.flink.sink.internal.committables.DeltaGlobalCommittable;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.util.Preconditions;

public class DeltaGlobalCommittableSerializer
implements SimpleVersionedSerializer<DeltaGlobalCommittable> {
    private static final int MAGIC_NUMBER = 511073408;
    private final DeltaCommittableSerializer deltaCommittableSerializer;

    public DeltaGlobalCommittableSerializer(SimpleVersionedSerializer<InProgressFileWriter.PendingFileRecoverable> simpleVersionedSerializer) {
        Preconditions.checkNotNull(simpleVersionedSerializer);
        this.deltaCommittableSerializer = new DeltaCommittableSerializer(simpleVersionedSerializer);
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(DeltaGlobalCommittable deltaGlobalCommittable) throws IOException {
        DataOutputSerializer dataOutputSerializer = new DataOutputSerializer(256);
        dataOutputSerializer.writeInt(511073408);
        this.serializeV1(deltaGlobalCommittable, (DataOutputView)dataOutputSerializer);
        return dataOutputSerializer.getCopyOfBuffer();
    }

    public DeltaGlobalCommittable deserialize(int n, byte[] byArray) throws IOException {
        DataInputDeserializer dataInputDeserializer = new DataInputDeserializer(byArray);
        if (n == 1) {
            DeltaGlobalCommittableSerializer.validateMagicNumber((DataInputView)dataInputDeserializer);
            return this.deserializeV1((DataInputView)dataInputDeserializer);
        }
        throw new IOException("Unrecognized version or corrupt state: " + n);
    }

    private void serializeV1(DeltaGlobalCommittable deltaGlobalCommittable, DataOutputView dataOutputView) throws IOException {
        dataOutputView.writeInt(deltaGlobalCommittable.getDeltaCommittables().size());
        for (DeltaCommittable deltaCommittable : deltaGlobalCommittable.getDeltaCommittables()) {
            this.deltaCommittableSerializer.serializeV1(deltaCommittable, dataOutputView);
        }
    }

    private DeltaGlobalCommittable deserializeV1(DataInputView dataInputView) throws IOException {
        int n = dataInputView.readInt();
        ArrayList<DeltaCommittable> arrayList = new ArrayList<DeltaCommittable>(n);
        for (int i = 0; i < n; ++i) {
            DeltaCommittable deltaCommittable = this.deltaCommittableSerializer.deserializeV1(dataInputView);
            arrayList.add(deltaCommittable);
        }
        return new DeltaGlobalCommittable(arrayList);
    }

    private static void validateMagicNumber(DataInputView dataInputView) throws IOException {
        int n = dataInputView.readInt();
        if (n != 511073408) {
            throw new IOException(String.format("Corrupt data: Unexpected magic number %08X", n));
        }
    }
}

