/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.sink.internal;

import io.delta.standalone.types.BinaryType;
import io.delta.standalone.types.BooleanType;
import io.delta.standalone.types.ByteType;
import io.delta.standalone.types.DataType;
import io.delta.standalone.types.DateType;
import io.delta.standalone.types.DecimalType;
import io.delta.standalone.types.DoubleType;
import io.delta.standalone.types.FloatType;
import io.delta.standalone.types.IntegerType;
import io.delta.standalone.types.LongType;
import io.delta.standalone.types.NullType;
import io.delta.standalone.types.ShortType;
import io.delta.standalone.types.StringType;
import io.delta.standalone.types.StructField;
import io.delta.standalone.types.StructType;
import io.delta.standalone.types.TimestampType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;

public class SchemaConverter {
    public static StructType toDeltaDataType(RowType rowType) {
        StructField[] structFieldArray = (StructField[])rowType.getFields().stream().map(rowField -> {
            DataType dataType = SchemaConverter.toDeltaDataType(rowField.getType());
            return new StructField(rowField.getName(), dataType, rowField.getType().isNullable());
        }).toArray(StructField[]::new);
        return new StructType(structFieldArray);
    }

    public static DataType toDeltaDataType(LogicalType logicalType) {
        switch (logicalType.getTypeRoot()) {
            case ARRAY: {
                ArrayType arrayType = (ArrayType)logicalType;
                LogicalType logicalType2 = arrayType.getElementType();
                DataType dataType = SchemaConverter.toDeltaDataType(logicalType2);
                return new io.delta.standalone.types.ArrayType(dataType, logicalType2.isNullable());
            }
            case BIGINT: {
                return new LongType();
            }
            case BINARY: 
            case VARBINARY: {
                return new BinaryType();
            }
            case BOOLEAN: {
                return new BooleanType();
            }
            case DATE: {
                return new DateType();
            }
            case DECIMAL: {
                org.apache.flink.table.types.logical.DecimalType decimalType = (org.apache.flink.table.types.logical.DecimalType)logicalType;
                return new DecimalType(decimalType.getPrecision(), decimalType.getScale());
            }
            case DOUBLE: {
                return new DoubleType();
            }
            case FLOAT: {
                return new FloatType();
            }
            case INTEGER: {
                return new IntegerType();
            }
            case MAP: {
                MapType mapType = (MapType)logicalType;
                DataType dataType = SchemaConverter.toDeltaDataType(mapType.getKeyType());
                DataType dataType2 = SchemaConverter.toDeltaDataType(mapType.getValueType());
                boolean bl = mapType.getValueType().isNullable();
                return new io.delta.standalone.types.MapType(dataType, dataType2, bl);
            }
            case NULL: {
                return new NullType();
            }
            case SMALLINT: {
                return new ShortType();
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return new TimestampType();
            }
            case TINYINT: {
                return new ByteType();
            }
            case CHAR: 
            case VARCHAR: {
                return new StringType();
            }
            case ROW: {
                return SchemaConverter.toDeltaDataType((RowType)logicalType);
            }
        }
        throw new UnsupportedOperationException("Type not supported: " + logicalType);
    }
}

