/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.sink.internal;

import io.delta.flink.internal.options.DeltaConnectorConfiguration;
import io.delta.flink.sink.internal.DeltaSinkInternal;
import io.delta.flink.sink.internal.committables.DeltaCommittable;
import io.delta.flink.sink.internal.committables.DeltaCommittableSerializer;
import io.delta.flink.sink.internal.committables.DeltaGlobalCommittable;
import io.delta.flink.sink.internal.committables.DeltaGlobalCommittableSerializer;
import io.delta.flink.sink.internal.committer.DeltaCommitter;
import io.delta.flink.sink.internal.committer.DeltaGlobalCommitter;
import io.delta.flink.sink.internal.writer.DeltaWriter;
import io.delta.flink.sink.internal.writer.DeltaWriterBucketState;
import io.delta.flink.sink.internal.writer.DeltaWriterBucketStateSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.UUID;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.flink.api.connector.sink.GlobalCommitter;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.formats.parquet.ParquetWriterFactory;
import org.apache.flink.formats.parquet.utils.SerializableConfiguration;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.DeltaBulkBucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputFileConfig;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.CheckpointRollingPolicy;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;

public class DeltaSinkBuilder<IN>
implements Serializable {
    private static final long serialVersionUID = 7493169281026370228L;
    protected static final long DEFAULT_BUCKET_CHECK_INTERVAL = 60000L;
    private final Path tableBasePath;
    private final RowType rowType;
    private final String appId;
    private boolean mergeSchema;
    private final DeltaConnectorConfiguration sinkConfiguration;
    private final SerializableConfiguration serializableConfiguration;
    private final long bucketCheckInterval;
    private final ParquetWriterFactory<IN> writerFactory;
    private BucketAssigner<IN, String> bucketAssigner;
    private final CheckpointRollingPolicy<IN, String> rollingPolicy;
    private final OutputFileConfig outputFileConfig;

    private static String generateNewAppId() {
        return UUID.randomUUID().toString();
    }

    protected DeltaSinkBuilder(Path path, Configuration configuration, ParquetWriterFactory<IN> parquetWriterFactory, BucketAssigner<IN, String> bucketAssigner, CheckpointRollingPolicy<IN, String> checkpointRollingPolicy, RowType rowType, boolean bl, DeltaConnectorConfiguration deltaConnectorConfiguration) {
        this(path, configuration, 60000L, parquetWriterFactory, bucketAssigner, checkpointRollingPolicy, OutputFileConfig.builder().withPartSuffix(".snappy.parquet").build(), DeltaSinkBuilder.generateNewAppId(), rowType, bl, deltaConnectorConfiguration);
    }

    protected DeltaSinkBuilder(Path path, Configuration configuration, long l, ParquetWriterFactory<IN> parquetWriterFactory, BucketAssigner<IN, String> bucketAssigner, CheckpointRollingPolicy<IN, String> checkpointRollingPolicy, OutputFileConfig outputFileConfig, String string, RowType rowType, boolean bl, DeltaConnectorConfiguration deltaConnectorConfiguration) {
        this.tableBasePath = (Path)Preconditions.checkNotNull((Object)path);
        this.serializableConfiguration = new SerializableConfiguration((Configuration)Preconditions.checkNotNull((Object)configuration));
        this.bucketCheckInterval = l;
        this.writerFactory = parquetWriterFactory;
        this.bucketAssigner = (BucketAssigner)Preconditions.checkNotNull(bucketAssigner);
        this.rollingPolicy = (CheckpointRollingPolicy)Preconditions.checkNotNull(checkpointRollingPolicy);
        this.outputFileConfig = (OutputFileConfig)Preconditions.checkNotNull((Object)outputFileConfig);
        this.appId = string;
        this.rowType = rowType;
        this.mergeSchema = bl;
        this.sinkConfiguration = deltaConnectorConfiguration;
    }

    public DeltaSinkBuilder<IN> withMergeSchema(boolean bl) {
        this.mergeSchema = bl;
        return this;
    }

    Committer<DeltaCommittable> createCommitter() throws IOException {
        return new DeltaCommitter((BucketWriter<?, ?>)this.createBucketWriter());
    }

    GlobalCommitter<DeltaCommittable, DeltaGlobalCommittable> createGlobalCommitter() {
        return new DeltaGlobalCommitter(this.serializableConfiguration.conf(), this.tableBasePath, this.rowType, this.mergeSchema);
    }

    protected Path getTableBasePath() {
        return this.tableBasePath;
    }

    protected String getAppId() {
        return this.appId;
    }

    protected SerializableConfiguration getSerializableConfiguration() {
        return this.serializableConfiguration;
    }

    public DeltaSinkBuilder<IN> withBucketAssigner(BucketAssigner<IN, String> bucketAssigner) {
        this.bucketAssigner = (BucketAssigner)Preconditions.checkNotNull(bucketAssigner);
        return this;
    }

    public DeltaSinkInternal<IN> build() {
        return new DeltaSinkInternal(this);
    }

    DeltaWriter<IN> createWriter(Sink.InitContext initContext, String string, long l) throws IOException {
        return new DeltaWriter<IN>(this.tableBasePath, this.bucketAssigner, this.createBucketWriter(), this.rollingPolicy, this.outputFileConfig, initContext.getProcessingTimeService(), (MetricGroup)initContext.metricGroup(), this.bucketCheckInterval, string, l);
    }

    SimpleVersionedSerializer<DeltaWriterBucketState> getWriterStateSerializer() throws IOException {
        return new DeltaWriterBucketStateSerializer();
    }

    SimpleVersionedSerializer<DeltaCommittable> getCommittableSerializer() throws IOException {
        DeltaBulkBucketWriter<IN, String> deltaBulkBucketWriter = this.createBucketWriter();
        return new DeltaCommittableSerializer((SimpleVersionedSerializer<InProgressFileWriter.PendingFileRecoverable>)deltaBulkBucketWriter.getProperties().getPendingFileRecoverableSerializer());
    }

    SimpleVersionedSerializer<DeltaGlobalCommittable> getGlobalCommittableSerializer() throws IOException {
        DeltaBulkBucketWriter<IN, String> deltaBulkBucketWriter = this.createBucketWriter();
        return new DeltaGlobalCommittableSerializer((SimpleVersionedSerializer<InProgressFileWriter.PendingFileRecoverable>)deltaBulkBucketWriter.getProperties().getPendingFileRecoverableSerializer());
    }

    private DeltaBulkBucketWriter<IN, String> createBucketWriter() throws IOException {
        return new DeltaBulkBucketWriter(FileSystem.get((URI)this.tableBasePath.toUri()).createRecoverableWriter(), this.writerFactory);
    }

    public static final class DefaultDeltaFormatBuilder<IN>
    extends DeltaSinkBuilder<IN> {
        private static final long serialVersionUID = 2818087325120827526L;

        public DefaultDeltaFormatBuilder(Path path, Configuration configuration, ParquetWriterFactory<IN> parquetWriterFactory, BucketAssigner<IN, String> bucketAssigner, CheckpointRollingPolicy<IN, String> checkpointRollingPolicy, RowType rowType, boolean bl, DeltaConnectorConfiguration deltaConnectorConfiguration) {
            super(path, configuration, parquetWriterFactory, bucketAssigner, checkpointRollingPolicy, rowType, bl, deltaConnectorConfiguration);
        }
    }
}

