/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.sink.internal;

import java.io.Serializable;
import java.util.LinkedHashMap;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;

public interface DeltaPartitionComputer<T>
extends Serializable {
    public LinkedHashMap<String, String> generatePartitionValues(T var1, BucketAssigner.Context var2);

    public static class DeltaRowDataPartitionComputer
    implements DeltaPartitionComputer<RowData> {
        private final LinkedHashMap<String, String> staticPartitionSpec;
        private final RowType rowType;
        String[] partitionColumns;

        public DeltaRowDataPartitionComputer(RowType rowType, String[] stringArray) {
            this(rowType, stringArray, new LinkedHashMap<String, String>());
        }

        public DeltaRowDataPartitionComputer(RowType rowType, String[] stringArray, LinkedHashMap<String, String> linkedHashMap) {
            this.rowType = rowType;
            this.partitionColumns = stringArray;
            this.staticPartitionSpec = linkedHashMap;
        }

        @Override
        public LinkedHashMap<String, String> generatePartitionValues(RowData rowData, BucketAssigner.Context context) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            for (String string : this.partitionColumns) {
                int n = this.rowType.getFieldIndex(string);
                LogicalType logicalType = this.rowType.getTypeAt(n);
                if (this.staticPartitionSpec.containsKey(string)) {
                    linkedHashMap.put(string, this.staticPartitionSpec.get(string));
                    continue;
                }
                if (logicalType.getTypeRoot() == LogicalTypeRoot.VARCHAR) {
                    linkedHashMap.put(string, rowData.getString(n).toString());
                    continue;
                }
                if (logicalType.getTypeRoot() == LogicalTypeRoot.INTEGER) {
                    linkedHashMap.put(string, String.valueOf(rowData.getInt(n)));
                    continue;
                }
                if (logicalType.getTypeRoot() == LogicalTypeRoot.BIGINT) {
                    linkedHashMap.put(string, String.valueOf(rowData.getLong(n)));
                    continue;
                }
                if (logicalType.getTypeRoot() == LogicalTypeRoot.SMALLINT) {
                    linkedHashMap.put(string, String.valueOf(rowData.getShort(n)));
                    continue;
                }
                if (logicalType.getTypeRoot() == LogicalTypeRoot.TINYINT) {
                    linkedHashMap.put(string, String.valueOf(rowData.getByte(n)));
                    continue;
                }
                throw new RuntimeException("Type not supported " + logicalType.getTypeRoot());
            }
            return linkedHashMap;
        }
    }
}

