/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.sink.internal;

import io.delta.flink.sink.internal.DeltaPartitionComputer;
import java.util.LinkedHashMap;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.SimpleVersionedStringSerializer;
import org.apache.flink.table.utils.PartitionPathUtils;

public class DeltaBucketAssigner<T>
implements BucketAssigner<T, String> {
    private static final long serialVersionUID = -6033643154550226022L;
    private final DeltaPartitionComputer<T> partitionComputer;

    public DeltaBucketAssigner(DeltaPartitionComputer<T> deltaPartitionComputer) {
        this.partitionComputer = deltaPartitionComputer;
    }

    public String getBucketId(T t, BucketAssigner.Context context) {
        LinkedHashMap<String, String> linkedHashMap = this.partitionComputer.generatePartitionValues(t, context);
        return PartitionPathUtils.generatePartitionPath(linkedHashMap);
    }

    public SimpleVersionedSerializer<String> getSerializer() {
        return SimpleVersionedStringSerializer.INSTANCE;
    }

    public String toString() {
        return "DeltaBucketAssigner";
    }
}

