/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.table;

import io.delta.flink.internal.table.CatalogExceptionHelper;
import io.delta.flink.internal.table.DeltaFlinkJobSpecificOptions;
import io.delta.flink.internal.table.DeltaTableConnectorOptions;
import io.delta.flink.internal.table.QueryOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.factories.FactoryUtil;

public final class DeltaTableFactoryHelper {
    private static final Set<String> OPTIONS_TO_IGNORE = Stream.of(FactoryUtil.CONNECTOR.key(), DeltaTableConnectorOptions.TABLE_PATH.key(), DeltaFlinkJobSpecificOptions.MODE.key()).collect(Collectors.toSet());

    private DeltaTableFactoryHelper() {
    }

    public static QueryOptions validateSourceQueryOptions(Configuration configuration) {
        DeltaTableFactoryHelper.validateDeltaTablePathOption(configuration);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry entry : configuration.toMap().entrySet()) {
            String string = (String)entry.getKey();
            if (OPTIONS_TO_IGNORE.contains(string)) continue;
            if (DeltaFlinkJobSpecificOptions.SOURCE_JOB_OPTIONS.contains(string)) {
                hashMap.put(string, (String)entry.getValue());
                continue;
            }
            arrayList.add(string);
        }
        if (!arrayList.isEmpty()) {
            throw CatalogExceptionHelper.invalidSelectJobPropertyException(arrayList);
        }
        return new QueryOptions((String)configuration.get(DeltaTableConnectorOptions.TABLE_PATH), (DeltaFlinkJobSpecificOptions.QueryMode)((Object)configuration.get(DeltaFlinkJobSpecificOptions.MODE)), hashMap);
    }

    public static QueryOptions validateSinkQueryOptions(Configuration configuration) {
        DeltaTableFactoryHelper.validateDeltaTablePathOption(configuration);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry entry : configuration.toMap().entrySet()) {
            String string = (String)entry.getKey();
            if (OPTIONS_TO_IGNORE.contains(string)) continue;
            arrayList.add(string);
        }
        if (!arrayList.isEmpty()) {
            throw CatalogExceptionHelper.invalidInsertJobPropertyException(arrayList);
        }
        return new QueryOptions((String)configuration.get(DeltaTableConnectorOptions.TABLE_PATH), (DeltaFlinkJobSpecificOptions.QueryMode)((Object)configuration.get(DeltaFlinkJobSpecificOptions.MODE)), hashMap);
    }

    public static void validateDeltaTablePathOption(Configuration configuration) {
        if (!configuration.contains(DeltaTableConnectorOptions.TABLE_PATH)) {
            throw new ValidationException("Missing path to Delta table");
        }
    }
}

