/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.table;

import io.delta.flink.internal.table.DeltaFlinkJobSpecificOptions;
import io.delta.flink.internal.table.QueryOptions;
import io.delta.flink.source.DeltaSource;
import io.delta.flink.source.internal.builder.DeltaSourceBuilderBase;
import java.util.List;
import java.util.Map;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceProvider;
import org.apache.hadoop.conf.Configuration;

public class DeltaDynamicTableSource
implements ScanTableSource {
    private final Configuration hadoopConf;
    private final QueryOptions queryOptions;
    private final List<String> columns;

    public DeltaDynamicTableSource(Configuration configuration, QueryOptions queryOptions, List<String> list) {
        this.hadoopConf = configuration;
        this.queryOptions = queryOptions;
        this.columns = list;
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.insertOnly();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        DeltaSourceBuilderBase deltaSourceBuilderBase;
        DeltaFlinkJobSpecificOptions.QueryMode queryMode = this.queryOptions.getQueryMode();
        String string = this.queryOptions.getDeltaTablePath();
        switch (queryMode) {
            case BATCH: {
                deltaSourceBuilderBase = DeltaSource.forBoundedRowData(new Path(string), this.hadoopConf);
                break;
            }
            case STREAMING: {
                deltaSourceBuilderBase = DeltaSource.forContinuousRowData(new Path(string), this.hadoopConf);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unrecognized table mode %s used for Delta table %s", new Object[]{queryMode, string}));
            }
        }
        deltaSourceBuilderBase.columnNames(this.columns);
        for (Map.Entry<String, String> entry : this.queryOptions.getJobSpecificOptions().entrySet()) {
            deltaSourceBuilderBase.option(entry.getKey(), entry.getValue());
        }
        return SourceProvider.of(deltaSourceBuilderBase.build());
    }

    public DynamicTableSource copy() {
        return new DeltaDynamicTableSource(this.hadoopConf, this.queryOptions, this.columns);
    }

    public String asSummaryString() {
        return "DeltaSource";
    }
}

