/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.table;

import io.delta.flink.internal.options.DeltaConnectorConfiguration;
import io.delta.flink.sink.internal.DeltaBucketAssigner;
import io.delta.flink.sink.internal.DeltaPartitionComputer;
import io.delta.flink.sink.internal.DeltaSinkBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.parquet.row.ParquetRowDataBuilder;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.BasePathBucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.OnCheckpointRollingPolicy;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkProvider;
import org.apache.flink.table.connector.sink.abilities.SupportsPartitioning;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.conf.Configuration;

public class DeltaDynamicTableSink
implements DynamicTableSink,
SupportsPartitioning {
    private static final boolean PARQUET_UTC_TIMESTAMP = true;
    private static final boolean MERGE_SCHEMA = false;
    private final Path basePath;
    private final Configuration hadoopConf;
    private final RowType rowType;
    private final CatalogTable catalogTable;
    private LinkedHashMap<String, String> staticPartitionSpec;

    public DeltaDynamicTableSink(Path path, Configuration configuration, RowType rowType, CatalogTable catalogTable) {
        this(path, configuration, rowType, catalogTable, new LinkedHashMap<String, String>());
    }

    private DeltaDynamicTableSink(Path path, Configuration configuration, RowType rowType, CatalogTable catalogTable, LinkedHashMap<String, String> linkedHashMap) {
        this.basePath = path;
        this.rowType = rowType;
        this.hadoopConf = configuration;
        this.catalogTable = catalogTable;
        this.staticPartitionSpec = linkedHashMap;
    }

    public ChangelogMode getChangelogMode(ChangelogMode changelogMode) {
        return ChangelogMode.insertOnly();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        DeltaSinkBuilder.DefaultDeltaFormatBuilder defaultDeltaFormatBuilder = new DeltaSinkBuilder.DefaultDeltaFormatBuilder(this.basePath, this.hadoopConf, ParquetRowDataBuilder.createWriterFactory((RowType)this.rowType, (Configuration)this.hadoopConf, (boolean)true), new BasePathBucketAssigner(), OnCheckpointRollingPolicy.build(), this.rowType, false, new DeltaConnectorConfiguration());
        if (this.catalogTable.isPartitioned()) {
            DeltaPartitionComputer.DeltaRowDataPartitionComputer deltaRowDataPartitionComputer = new DeltaPartitionComputer.DeltaRowDataPartitionComputer(this.rowType, this.catalogTable.getPartitionKeys().toArray(new String[0]), this.staticPartitionSpec);
            DeltaBucketAssigner<RowData> deltaBucketAssigner = new DeltaBucketAssigner<RowData>(deltaRowDataPartitionComputer);
            defaultDeltaFormatBuilder.withBucketAssigner(deltaBucketAssigner);
        }
        return SinkProvider.of(defaultDeltaFormatBuilder.build());
    }

    public DynamicTableSink copy() {
        return new DeltaDynamicTableSink(this.basePath, this.hadoopConf, this.rowType, this.catalogTable, new LinkedHashMap<String, String>(this.staticPartitionSpec));
    }

    public String asSummaryString() {
        return "DeltaSink";
    }

    public void applyStaticPartition(Map<String, String> map) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (String string : this.catalogTable.getPartitionKeys()) {
            if (!map.containsKey(string)) continue;
            linkedHashMap.put(string, map.get(string));
        }
        this.staticPartitionSpec = linkedHashMap;
    }

    @VisibleForTesting
    Configuration getHadoopConf() {
        return new Configuration(this.hadoopConf);
    }
}

