/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.table;

import io.delta.flink.internal.table.DeltaDynamicTableSink;
import io.delta.flink.internal.table.DeltaDynamicTableSource;
import io.delta.flink.internal.table.DeltaTableConnectorOptions;
import io.delta.flink.internal.table.DeltaTableFactoryHelper;
import io.delta.flink.internal.table.HadoopUtils;
import io.delta.flink.internal.table.QueryOptions;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.logical.RowType;

public class DeltaDynamicTableFactory
implements DynamicTableSinkFactory,
DynamicTableSourceFactory {
    public static final String DELTA_CONNECTOR_IDENTIFIER = "delta";
    public final boolean isFromCatalog;

    public DeltaDynamicTableFactory() {
        this.isFromCatalog = false;
    }

    private DeltaDynamicTableFactory(boolean bl) {
        if (!bl) {
            throw new RuntimeException("FromCatalog parameter must be set to true.");
        }
        this.isFromCatalog = true;
    }

    static DeltaDynamicTableFactory fromCatalog() {
        return new DeltaDynamicTableFactory(true);
    }

    public String factoryIdentifier() {
        return DELTA_CONNECTOR_IDENTIFIER;
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        if (!this.isFromCatalog) {
            throw this.notFromDeltaCatalogException();
        }
        FactoryUtil.TableFactoryHelper tableFactoryHelper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        Configuration configuration = this.getQueryOptions(tableFactoryHelper);
        String string = (String)configuration.get(FactoryUtil.CONNECTOR);
        if (!DELTA_CONNECTOR_IDENTIFIER.equals(string)) {
            DynamicTableSinkFactory dynamicTableSinkFactory = (DynamicTableSinkFactory)FactoryUtil.discoverFactory((ClassLoader)this.getClass().getClassLoader(), DynamicTableSinkFactory.class, (String)string);
            return dynamicTableSinkFactory.createDynamicTableSink(context);
        }
        DeltaTableFactoryHelper.validateSinkQueryOptions(configuration);
        ResolvedSchema resolvedSchema = context.getCatalogTable().getResolvedSchema();
        org.apache.hadoop.conf.Configuration configuration2 = HadoopUtils.getHadoopConfiguration(GlobalConfiguration.loadConfiguration());
        RowType rowType = (RowType)resolvedSchema.toSinkRowDataType().getLogicalType();
        return new DeltaDynamicTableSink(new Path((String)configuration.get(DeltaTableConnectorOptions.TABLE_PATH)), configuration2, rowType, (CatalogTable)context.getCatalogTable());
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        if (!this.isFromCatalog) {
            throw this.notFromDeltaCatalogException();
        }
        FactoryUtil.TableFactoryHelper tableFactoryHelper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        Configuration configuration = this.getQueryOptions(tableFactoryHelper);
        String string = (String)configuration.get(FactoryUtil.CONNECTOR);
        if (!DELTA_CONNECTOR_IDENTIFIER.equals(string)) {
            DynamicTableSourceFactory dynamicTableSourceFactory = (DynamicTableSourceFactory)FactoryUtil.discoverFactory((ClassLoader)this.getClass().getClassLoader(), DynamicTableSourceFactory.class, (String)string);
            return dynamicTableSourceFactory.createDynamicTableSource(context);
        }
        QueryOptions queryOptions = DeltaTableFactoryHelper.validateSourceQueryOptions(configuration);
        org.apache.hadoop.conf.Configuration configuration2 = HadoopUtils.getHadoopConfiguration(GlobalConfiguration.loadConfiguration());
        List list = ((RowType)context.getCatalogTable().getResolvedSchema().toPhysicalRowDataType().getLogicalType()).getFieldNames();
        return new DeltaDynamicTableSource(configuration2, queryOptions, list);
    }

    public Set<ConfigOption<?>> forwardOptions() {
        HashSet hashSet = new HashSet();
        hashSet.add(DeltaTableConnectorOptions.TABLE_PATH);
        return hashSet;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Collections.emptySet();
    }

    private RuntimeException notFromDeltaCatalogException() {
        return new RuntimeException("Delta Table SQL/Table API was used without Delta Catalog. It is required to use Delta Catalog with all Flink SQL operations that involve Delta table. Please see documentation for details -> TODO DC add link to docs");
    }

    private Configuration getQueryOptions(FactoryUtil.TableFactoryHelper tableFactoryHelper) {
        return (Configuration)tableFactoryHelper.getOptions();
    }
}

