/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.table;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.delta.flink.internal.table.DeltaCatalogBaseTable;
import io.delta.flink.internal.table.DeltaCatalogTableHelper;
import io.delta.flink.internal.table.DeltaTableConnectorOptions;
import io.delta.standalone.DeltaLog;
import io.delta.standalone.Operation;
import io.delta.standalone.Snapshot;
import io.delta.standalone.actions.Metadata;
import io.delta.standalone.types.StructType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.apache.hadoop.conf.Configuration;

public class DeltaCatalog {
    private static final String DEFAULT_TABLE_CACHE_SIZE = "100";
    private final String catalogName;
    private final Catalog decoratedCatalog;
    private final LoadingCache<DeltaLogCacheKey, DeltaLog> deltaLogCache;

    DeltaCatalog(String string, Catalog catalog, final Configuration configuration) {
        this.catalogName = string;
        this.decoratedCatalog = catalog;
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)string) ? 1 : 0) != 0, (Object)"Catalog name cannot be null or empty.");
        Preconditions.checkArgument((catalog != null ? 1 : 0) != 0, (Object)"The decoratedCatalog cannot be null.");
        Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (Object)"The Hadoop Configuration object - 'hadoopConfiguration' cannot be null.");
        long l = Long.parseLong(configuration.get("deltaCatalogTableCacheSize", DEFAULT_TABLE_CACHE_SIZE));
        this.deltaLogCache = CacheBuilder.newBuilder().maximumSize(l).build((CacheLoader)new CacheLoader<DeltaLogCacheKey, DeltaLog>(){

            @ParametersAreNonnullByDefault
            public DeltaLog load(DeltaLogCacheKey deltaLogCacheKey) {
                return DeltaLog.forTable((Configuration)configuration, (String)deltaLogCacheKey.deltaTablePath);
            }
        });
    }

    public void createTable(DeltaCatalogBaseTable deltaCatalogBaseTable, boolean bl) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)deltaCatalogBaseTable);
        ObjectPath objectPath = deltaCatalogBaseTable.getTableCatalogPath();
        if (this.decoratedCatalog.tableExists(objectPath) && !bl) {
            throw new TableAlreadyExistException(this.catalogName, objectPath);
        }
        if (!this.decoratedCatalog.databaseExists(deltaCatalogBaseTable.getDatabaseName())) {
            throw new DatabaseNotExistException(this.catalogName, deltaCatalogBaseTable.getDatabaseName());
        }
        Map<String, String> map = deltaCatalogBaseTable.getOptions();
        String string = map.get(DeltaTableConnectorOptions.TABLE_PATH.key());
        if (StringUtils.isNullOrWhitespaceOnly((String)string)) {
            throw new CatalogException("Path to Delta table cannot be null or empty.");
        }
        DeltaCatalogTableHelper.validateDdlOptions(map);
        Map<String, String> map2 = DeltaCatalogTableHelper.filterMetastoreDdlOptions(map);
        CatalogBaseTable catalogBaseTable = deltaCatalogBaseTable.getCatalogTable();
        List list = ((CatalogTable)catalogBaseTable).getPartitionKeys();
        StructType structType = DeltaCatalogTableHelper.resolveDeltaSchemaFromDdl((ResolvedCatalogTable)catalogBaseTable);
        DeltaLog deltaLog = this.getDeltaLogFromCache(deltaCatalogBaseTable, string);
        if (deltaLog.tableExists()) {
            DeltaCatalogTableHelper.DeltaMetastoreTable deltaMetastoreTable;
            Metadata metadata = deltaLog.update().getMetadata();
            DeltaCatalogTableHelper.validateDdlSchemaAndPartitionSpecMatchesDelta(string, objectPath, list, structType, metadata);
            Map<String, String> map3 = DeltaCatalogTableHelper.prepareDeltaTableProperties(map2, objectPath, metadata, false);
            if (map3.size() != metadata.getConfiguration().size()) {
                deltaMetastoreTable = metadata.copyBuilder().configuration(map3).build();
                DeltaCatalogTableHelper.commitToDeltaLog(deltaLog, (Metadata)deltaMetastoreTable, Operation.Name.SET_TABLE_PROPERTIES);
            }
            deltaMetastoreTable = DeltaCatalogTableHelper.prepareMetastoreTable(catalogBaseTable, string);
            this.decoratedCatalog.createTable(objectPath, (CatalogBaseTable)deltaMetastoreTable, bl);
        } else {
            Metadata metadata = Metadata.builder().schema(structType).partitionColumns(list).configuration(map2).name(objectPath.getObjectName()).build();
            DeltaCatalogTableHelper.commitToDeltaLog(deltaLog, metadata, Operation.Name.CREATE_TABLE);
            DeltaCatalogTableHelper.DeltaMetastoreTable deltaMetastoreTable = DeltaCatalogTableHelper.prepareMetastoreTable(catalogBaseTable, string);
            this.decoratedCatalog.createTable(objectPath, (CatalogBaseTable)deltaMetastoreTable, bl);
        }
    }

    public void dropTable(DeltaCatalogBaseTable deltaCatalogBaseTable, boolean bl) throws TableNotExistException {
        CatalogBaseTable catalogBaseTable = deltaCatalogBaseTable.getCatalogTable();
        String string = (String)catalogBaseTable.getOptions().get(DeltaTableConnectorOptions.TABLE_PATH.key());
        ObjectPath objectPath = deltaCatalogBaseTable.getTableCatalogPath();
        this.deltaLogCache.invalidate((Object)new DeltaLogCacheKey(objectPath, string));
        this.decoratedCatalog.dropTable(objectPath, bl);
    }

    public CatalogBaseTable getTable(DeltaCatalogBaseTable deltaCatalogBaseTable) throws TableNotExistException {
        CatalogBaseTable catalogBaseTable = deltaCatalogBaseTable.getCatalogTable();
        String string = (String)catalogBaseTable.getOptions().get(DeltaTableConnectorOptions.TABLE_PATH.key());
        DeltaLog deltaLog = this.getDeltaLogFromCache(deltaCatalogBaseTable, string);
        Snapshot snapshot = deltaLog.update();
        if (!deltaLog.tableExists()) {
            throw new TableNotExistException(this.catalogName, deltaCatalogBaseTable.getTableCatalogPath(), (Throwable)new CatalogException(String.format("Table %s exists in metastore but _delta_log was not found under path %s", deltaCatalogBaseTable.getTableCatalogPath().getFullName(), string)));
        }
        Metadata metadata = snapshot.getMetadata();
        StructType structType = metadata.getSchema();
        if (structType == null) {
            throw new CatalogException(String.format("Delta schema is null for table %s and table path %s. Please contact your administrator.", deltaCatalogBaseTable.getCatalogTable(), string));
        }
        Pair<String[], DataType[]> pair = DeltaCatalogTableHelper.resolveFlinkTypesFromDelta(structType);
        return CatalogTable.of((Schema)Schema.newBuilder().fromFields((String[])pair.getKey(), (AbstractDataType[])pair.getValue()).build(), (String)catalogBaseTable.getComment(), (List)metadata.getPartitionColumns(), (Map)catalogBaseTable.getOptions());
    }

    public boolean tableExists(DeltaCatalogBaseTable deltaCatalogBaseTable) {
        CatalogBaseTable catalogBaseTable = deltaCatalogBaseTable.getCatalogTable();
        String string = (String)catalogBaseTable.getOptions().get(DeltaTableConnectorOptions.TABLE_PATH.key());
        return this.getDeltaLogFromCache(deltaCatalogBaseTable, string).tableExists();
    }

    public void alterTable(DeltaCatalogBaseTable deltaCatalogBaseTable) {
        Map<String, String> map = deltaCatalogBaseTable.getOptions();
        String string = map.get(DeltaTableConnectorOptions.TABLE_PATH.key());
        DeltaCatalogTableHelper.validateDdlOptions(map);
        Map<String, String> map2 = DeltaCatalogTableHelper.filterMetastoreDdlOptions(map);
        DeltaLog deltaLog = this.getDeltaLogFromCache(deltaCatalogBaseTable, string);
        Metadata metadata = deltaLog.update().getMetadata();
        Map<String, String> map3 = DeltaCatalogTableHelper.prepareDeltaTableProperties(map2, deltaCatalogBaseTable.getTableCatalogPath(), metadata, true);
        Metadata metadata2 = metadata.copyBuilder().configuration(map3).build();
        DeltaCatalogTableHelper.commitToDeltaLog(deltaLog, metadata2, Operation.Name.SET_TABLE_PROPERTIES);
    }

    private DeltaLog getDeltaLogFromCache(DeltaCatalogBaseTable deltaCatalogBaseTable, String string) {
        return (DeltaLog)this.deltaLogCache.getUnchecked((Object)new DeltaLogCacheKey(deltaCatalogBaseTable.getTableCatalogPath(), string));
    }

    @VisibleForTesting
    LoadingCache<DeltaLogCacheKey, DeltaLog> getDeltaLogCache() {
        return this.deltaLogCache;
    }

    static class DeltaLogCacheKey {
        private final ObjectPath objectPath;
        private final String deltaTablePath;

        DeltaLogCacheKey(ObjectPath objectPath, String string) {
            this.objectPath = objectPath;
            this.deltaTablePath = string;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            DeltaLogCacheKey deltaLogCacheKey = (DeltaLogCacheKey)object;
            return this.objectPath.equals((Object)deltaLogCacheKey.objectPath) && this.deltaTablePath.equals(deltaLogCacheKey.deltaTablePath);
        }

        public int hashCode() {
            return Objects.hash(this.objectPath, this.deltaTablePath);
        }
    }
}

