/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.table;

import io.delta.flink.internal.table.DeltaCatalogContext;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalogFactory;
import org.apache.flink.table.catalog.hive.factories.HiveCatalogFactory;
import org.apache.flink.table.factories.CatalogFactory;

public interface CatalogLoader
extends Serializable {
    public Catalog createCatalog(CatalogFactory.Context var1);

    public static CatalogLoader inMemory() {
        return new InMemoryCatalogLoader();
    }

    public static CatalogLoader hive() {
        return new HiveCatalogLoader();
    }

    default public CatalogFactory.Context filterDeltaCatalogOptions(CatalogFactory.Context context) {
        HashMap<String, String> hashMap = new HashMap<String, String>(context.getOptions());
        hashMap.remove("catalog-type");
        return new DeltaCatalogContext(context.getName(), hashMap, context.getConfiguration(), context.getClassLoader());
    }

    public static class HiveCatalogLoader
    implements CatalogLoader {
        @Override
        public Catalog createCatalog(CatalogFactory.Context context) {
            CatalogFactory.Context context2 = this.filterDeltaCatalogOptions(context);
            return new HiveCatalogFactory().createCatalog(context2);
        }
    }

    public static class InMemoryCatalogLoader
    implements CatalogLoader {
        @Override
        public Catalog createCatalog(CatalogFactory.Context context) {
            CatalogFactory.Context context2 = this.filterDeltaCatalogOptions(context);
            return new GenericInMemoryCatalogFactory().createCatalog(context2);
        }
    }
}

