/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.options;

import io.delta.flink.internal.options.DeltaConfigOption;
import io.delta.flink.internal.options.DeltaConnectorConfiguration;
import io.delta.flink.internal.options.DeltaOptionValidationException;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.core.fs.Path;

public class OptionValidator {
    private final Path tablePath;
    private final Map<String, DeltaConfigOption<?>> validOptions;
    private final DeltaConnectorConfiguration config;

    public OptionValidator(Path path, DeltaConnectorConfiguration deltaConnectorConfiguration, Map<String, DeltaConfigOption<?>> map) {
        this.tablePath = path;
        this.config = deltaConnectorConfiguration;
        this.validOptions = map;
    }

    public void option(String string, String string2) {
        this.tryToSetOption(() -> {
            DeltaConfigOption deltaConfigOption = this.validateOptionName(string);
            deltaConfigOption.setOnConfig(this.config, string2);
        });
    }

    public void option(String string, boolean bl) {
        this.tryToSetOption(() -> {
            DeltaConfigOption deltaConfigOption = this.validateOptionName(string);
            deltaConfigOption.setOnConfig(this.config, bl);
        });
    }

    public void option(String string, int n) {
        this.tryToSetOption(() -> {
            DeltaConfigOption deltaConfigOption = this.validateOptionName(string);
            deltaConfigOption.setOnConfig(this.config, n);
        });
    }

    public void option(String string, long l) {
        this.tryToSetOption(() -> {
            DeltaConfigOption deltaConfigOption = this.validateOptionName(string);
            deltaConfigOption.setOnConfig(this.config, l);
        });
    }

    private void tryToSetOption(Executable executable) {
        try {
            executable.execute();
        }
        catch (Exception exception) {
            throw OptionValidator.optionValidationException(this.tablePath, exception);
        }
    }

    protected <TYPE> DeltaConfigOption<TYPE> validateOptionName(String string) {
        DeltaConfigOption<?> deltaConfigOption = this.validOptions.get(string);
        if (deltaConfigOption == null) {
            throw OptionValidator.invalidOptionName(this.tablePath, string);
        }
        return deltaConfigOption;
    }

    private static DeltaOptionValidationException invalidOptionName(Path path, String string) {
        return new DeltaOptionValidationException(path, Collections.singletonList(String.format("Invalid option [%s] used for Delta Connector.", string)));
    }

    private static DeltaOptionValidationException optionValidationException(Path path, Exception exception) {
        return new DeltaOptionValidationException(path, Collections.singletonList(exception.getClass() + " - " + exception.getMessage()));
    }

    @FunctionalInterface
    private static interface Executable {
        public void execute();
    }
}

