/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.options;

import io.delta.flink.internal.options.BaseOptionTypeConverter;
import io.delta.flink.internal.options.DeltaConfigOption;
import io.delta.flink.internal.options.OptionType;
import org.apache.flink.util.StringUtils;

public class NonNegativeNumberTypeConverter<TYPE extends Number>
extends BaseOptionTypeConverter<TYPE> {
    @Override
    public <T> T convertType(DeltaConfigOption<T> deltaConfigOption, String string) {
        Number number;
        Class<T> clazz = deltaConfigOption.getValueType();
        OptionType optionType = OptionType.instanceFrom(clazz);
        if (StringUtils.isNullOrWhitespaceOnly((String)string)) {
            throw this.invalidValueException(deltaConfigOption.key(), string);
        }
        switch (optionType) {
            case LONG: {
                number = Long.parseLong(string);
                break;
            }
            case INTEGER: {
                number = Integer.parseInt(string);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("NonNegativeNumberTypeConverter used with a incompatible DeltaConfigOption option type. This converter must be used only for DeltaConfigOption::<? extends Number> however it was used for '%s' with option '%s'", deltaConfigOption.getValueType(), deltaConfigOption.key()));
            }
        }
        if (number.longValue() >= 0L) {
            return (T)number;
        }
        throw this.invalidValueException(deltaConfigOption.key(), string);
    }

    private IllegalArgumentException invalidValueException(String string, String string2) {
        return new IllegalArgumentException(String.format("Illegal value used for [%s] option. Expected values are non-negative integers. Used value was [%s]", string, string2));
    }
}

