/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.options;

import io.delta.flink.internal.options.BaseOptionTypeConverter;
import io.delta.flink.internal.options.DeltaConfigOption;
import io.delta.flink.internal.options.OptionType;

public final class DefaultOptionTypeConverter
extends BaseOptionTypeConverter<Object> {
    private static final String TYPE_EXCEPTION_MSG = "Unsupported value type {%s] for option [%s]";

    @Override
    public <T> T convertType(DeltaConfigOption<T> deltaConfigOption, String string) {
        Class<T> clazz = deltaConfigOption.getValueType();
        OptionType optionType = OptionType.instanceFrom(clazz);
        switch (optionType) {
            case STRING: {
                return (T)string;
            }
            case BOOLEAN: {
                return (T)Boolean.valueOf(string);
            }
            case INTEGER: {
                return (T)Integer.valueOf(string);
            }
            case LONG: {
                return (T)Long.valueOf(string);
            }
        }
        throw new IllegalArgumentException(String.format(TYPE_EXCEPTION_MSG, clazz, deltaConfigOption.key()));
    }
}

